/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandBack
extends ElementsMinewacheRolePlayMod.ModElement {
    public static Map<EntityPlayerMP, BlockPos> lastPositions = new HashMap<EntityPlayerMP, BlockPos>();
    String standardFarbe = Dateiverwaltung.standard;
    String warningFarbe = Dateiverwaltung.warning;
    String errorFarbe = Dateiverwaltung.error;
    String sucessFarbe = Dateiverwaltung.sucess;
    String playernameFarbe = Dateiverwaltung.playername;
    String sendernameFarbe = Dateiverwaltung.sendername;

    public CommandBack(ElementsMinewacheRolePlayMod instance) {
        super(instance, 291);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        BlockPos currentPosition = player.func_180425_c();
        lastPositions.put(player, currentPosition);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onCommandEvent(CommandEvent event) {
        if (event.getSender() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getSender();
            String command = event.getCommand().func_71517_b();
            if (command.equals("tp") || command.equals("teleport") || command.equals("spawn") || command.equals("warp") || command.equals("tpa")) {
                this.updateLastPosition(player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            this.updateLastPosition(player);
        }
    }

    private void updateLastPosition(EntityPlayerMP player) {
        if (player != null) {
            BlockPos currentPosition = player.func_180425_c();
            lastPositions.put(player, currentPosition);
        }
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public class CommandHandler
    extends CommandBase {
        public String func_71517_b() {
            return "back";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/back";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (sender instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)sender;
                BlockPos lastPos = lastPositions.get(player);
                if (lastPos != null) {
                    player.func_70634_a((double)lastPos.func_177958_n(), (double)lastPos.func_177956_o(), (double)lastPos.func_177952_p());
                    LangNetworkHandler.sendTranslationMessage(sender, "message.back.success", Dateiverwaltung.sucess, new Object[0]);
                } else {
                    LangNetworkHandler.sendTranslationMessage(sender, "message.back.noposition", Dateiverwaltung.error, new Object[0]);
                }
            } else {
                LangNetworkHandler.sendTranslationMessage(sender, "message.back.playeronly", Dateiverwaltung.error, new Object[0]);
            }
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] args, int index) {
            return false;
        }
    }
}

