/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandDelwarp
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandDelwarp(ElementsMinewacheRolePlayMod instance) {
        super(instance, 308);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    implements ICommand {
        String standardFarbe = Dateiverwaltung.standard;
        String warningFarbe = Dateiverwaltung.warning;
        String sucessFarbe = Dateiverwaltung.sucess;
        String warpnameFarbe = Dateiverwaltung.warpname;
        String errorFarbe = Dateiverwaltung.error;

        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, "minewachemod.command.delwarp");
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                ArrayList<String> warpNames = new ArrayList<String>();
                try {
                    String line;
                    String fileName = server.func_71218_a(0).func_72860_G().func_75765_b().getPath() + "/Minewachemod/WARPS.warpinfo";
                    BufferedReader reader = new BufferedReader(new FileReader(fileName));
                    while ((line = reader.readLine()) != null) {
                        if (!line.contains("{")) continue;
                        String warpName = line.substring(0, line.indexOf("{")).trim();
                        warpNames.add(warpName);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return warpNames;
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] string, int index) {
            return false;
        }

        public String func_71517_b() {
            return "delwarp";
        }

        public String func_71518_a(ICommandSender sender) {
            return new TextComponentTranslation("command.delwarp.usage", new Object[0]).func_150260_c();
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] cmd) {
            if (cmd.length != 1) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.delwarp.usage", this.standardFarbe, new Object[0]);
                return;
            }
            String warpName = cmd[0];
            File directory = new File(server.func_71218_a(0).func_72860_G().func_75765_b(), "Minewachemod");
            File file = new File(directory, "WARPS.warpinfo");
            if (!file.exists()) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.delwarp.list_empty", this.warningFarbe, new Object[0]);
                return;
            }
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                ArrayList<String> lines = new ArrayList<String>();
                boolean warpFound = false;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith(warpName + " {")) {
                        warpFound = true;
                        for (int i = 0; i < 6; ++i) {
                            reader.readLine();
                        }
                        continue;
                    }
                    lines.add(line);
                }
                reader.close();
                if (!warpFound) {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.delwarp.not_found", this.warningFarbe, warpName);
                    return;
                }
                FileWriter writer = new FileWriter(file);
                for (String newLine : lines) {
                    writer.write(newLine + "\n");
                }
                writer.close();
                LangNetworkHandler.sendTranslationMessage(sender, "command.delwarp.deleted", this.sucessFarbe, warpName);
            }
            catch (IOException e) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.delwarp.delete_error", this.errorFarbe, new Object[0]);
                e.printStackTrace();
            }
        }
    }
}

