/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import com.google.gson.Gson;
import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.gui.builder.storage.CustomGuiDef;
import de.sarocesch.minewacheroleplaymod.gui.builder.storage.CustomGuiStorage;
import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.PacketOpenCustomGui;
import de.sarocesch.minewacheroleplaymod.network.PacketOpenGuiBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandGuiManager
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandGuiManager(ElementsMinewacheRolePlayMod instance) {
        super(instance, 9999);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new Handler());
    }

    public static class Handler
    implements ICommand {
        public String func_71517_b() {
            return "gui";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/gui create <name> | /gui delete <name> | /gui open <name> | /gui edit <name>";
        }

        public List<String> func_71514_a() {
            ArrayList<String> a = new ArrayList<String>();
            a.add("guimgr");
            return a;
        }

        public int compareTo(ICommand o) {
            return this.func_71517_b().compareTo(o.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            ArrayList<String> res = new ArrayList<String>();
            if (args.length == 1) {
                res.add("create");
                res.add("delete");
                res.add("open");
                res.add("edit");
            }
            if (args.length == 2 && ("delete".equalsIgnoreCase(args[0]) || "open".equalsIgnoreCase(args[0]) || "edit".equalsIgnoreCase(args[0]))) {
                res.addAll(CustomGuiStorage.listAll());
            }
            return res;
        }

        public boolean func_82358_a(String[] args, int index) {
            return false;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (!(sender instanceof EntityPlayer)) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Must be a player."));
                return;
            }
            if (args.length < 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + this.func_71518_a(sender)));
                return;
            }
            String sub = args[0];
            String name = args[1];
            if (!name.matches("[a-zA-Z0-9_-]{1,32}")) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid name. Use alphanumerics, underscore, dash, max 32."));
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            if ("create".equalsIgnoreCase(sub)) {
                NetworkHandler.INSTANCE.sendTo((IMessage)new PacketOpenGuiBuilder(name), player);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Opening GUI builder for '" + name + "'"));
            } else if ("edit".equalsIgnoreCase(sub)) {
                try {
                    CustomGuiDef def = CustomGuiStorage.load(name);
                    if (def == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "GUI '" + name + "' not found"));
                        return;
                    }
                    String json = new Gson().toJson((Object)def);
                    NetworkHandler.INSTANCE.sendTo((IMessage)new PacketOpenGuiBuilder(name, json), player);
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Editing GUI '" + name + "'"));
                }
                catch (Exception e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error loading GUI: " + e.getMessage()));
                }
            } else if ("delete".equalsIgnoreCase(sub)) {
                boolean ok = CustomGuiStorage.delete(name);
                sender.func_145747_a((ITextComponent)new TextComponentString(ok ? TextFormatting.GREEN + "Deleted '" + name + "'" : TextFormatting.RED + "GUI '" + name + "' not found"));
            } else if ("open".equalsIgnoreCase(sub)) {
                try {
                    CustomGuiDef def = CustomGuiStorage.load(name);
                    if (def == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "GUI '" + name + "' not found"));
                        return;
                    }
                    String json = new Gson().toJson((Object)def);
                    NetworkHandler.INSTANCE.sendTo((IMessage)new PacketOpenCustomGui(name, json), player);
                }
                catch (Exception e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error loading GUI: " + e.getMessage()));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + this.func_71518_a(sender)));
            }
        }
    }
}

