/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.block.BlockJobBlock;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandJob
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandJob(ElementsMinewacheRolePlayMod instance) {
        super(instance, 305);
    }

    public static double getRankSalary(String jobName, String rankName) {
        File rankDir = new File("config/minewache/mw-ranks/ranks");
        File jobFile = new File(rankDir, jobName + ".txt");
        try {
            if (jobFile.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(jobFile));
                while ((line = reader.readLine()) != null) {
                    String[] parts = line.split(";");
                    if (parts.length < 2 || !parts[0].equals(rankName)) continue;
                    reader.close();
                    return Double.parseDouble(parts[1]);
                }
                reader.close();
            }
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    implements ICommand {
        private String jobToDelete = "";

        public static List<String> getListOfStringsMatchingLastWord(String[] args, String ... possibilities) {
            String s = args[args.length - 1];
            ArrayList<String> list = new ArrayList<String>();
            for (String s1 : possibilities) {
                if (!s1.startsWith(s)) continue;
                list.add(s1);
            }
            return list;
        }

        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, this.func_71517_b());
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                return CommandHandler.getListOfStringsMatchingLastWord(args, "create", "delete", "list", "dconfirm", "createrank", "deleterank", "addrank", "removerank", "ranklist", "setblock");
            }
            if (args.length == 2 && (args[0].equalsIgnoreCase("create") || args[0].equalsIgnoreCase("delete") || args[0].equalsIgnoreCase("createrank") || args[0].equalsIgnoreCase("ranklist") || args[0].equalsIgnoreCase("deleterank") || args[0].equalsIgnoreCase("addrank"))) {
                if (args[0].equalsIgnoreCase("delete") || args[0].equalsIgnoreCase("createrank") || args[0].equalsIgnoreCase("ranklist") || args[0].equalsIgnoreCase("deleterank") || args[0].equalsIgnoreCase("addrank") || args[0].equalsIgnoreCase("removerank")) {
                    File rankConfig = new File("config/minewache/mw-ranks/mw-ranks.cfg");
                    Configuration config = new Configuration(rankConfig);
                    config.load();
                    String[] jobNames = config.getCategory("jobs").keySet().toArray(new String[0]);
                    return CommandHandler.getListOfStringsMatchingLastWord(args, jobNames);
                }
                return null;
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("addrank")) {
                if (args[0].equalsIgnoreCase("addrank")) {
                    File rankConfig = new File("config/minewache/mw-ranks/mw-ranks.cfg");
                    Configuration config = new Configuration(rankConfig);
                    config.load();
                    String jobName = args[1];
                    String[] rankNames = this.getRankNamesForJob(config, jobName);
                    return CommandHandler.getListOfStringsMatchingLastWord(args, rankNames);
                }
                return new ArrayList<String>();
            }
            if ((args.length == 2 || args.length == 3 || args.length == 4) && args[0].equalsIgnoreCase("setblock")) {
                ArrayList<String> itemNames = new ArrayList<String>();
                for (Object item : Item.field_150901_e) {
                    if (!(item instanceof Item)) continue;
                    itemNames.add(((Item)item).getRegistryName().toString());
                }
                return CommandHandler.getListOfStringsMatchingLastWord(args, itemNames.toArray(new String[0]));
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("addrank")) {
                List<String> playerNames = Arrays.asList(server.func_71213_z());
                return CommandHandler.getListOfStringsMatchingLastWord(args, playerNames.toArray(new String[0]));
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("removerank")) {
                List<String> playerNames = Arrays.asList(server.func_71213_z());
                return CommandHandler.getListOfStringsMatchingLastWord(args, playerNames.toArray(new String[0]));
            }
            return new ArrayList<String>();
        }

        private String[] getRankNamesForJob(Configuration config, String jobName) {
            String[] rankNames = new String[]{};
            try {
                File rankDir = new File(config.getConfigFile().getParentFile(), "ranks");
                File jobFile = new File(rankDir, jobName + ".txt");
                if (jobFile.exists()) {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(jobFile));
                    ArrayList<String> ranks = new ArrayList<String>();
                    while ((line = reader.readLine()) != null) {
                        String[] parts = line.split(";");
                        if (parts.length <= 0) continue;
                        ranks.add(parts[0]);
                    }
                    reader.close();
                    rankNames = ranks.toArray(new String[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return rankNames;
        }

        public boolean func_82358_a(String[] string, int index) {
            return false;
        }

        public String func_71517_b() {
            return "job";
        }

        public String func_71518_a(ICommandSender var1) {
            return "/job create <name> | /job delete <name> | /job list | /job createrank <jobname> <rankname> <geld> | /job deleterank <playername> | /job addrank <jobname> <rankname> <playername> | /job removerank <playername> | /job ranklist | /job setblock";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            File jobDir;
            File rankDir;
            if (args.length < 1) {
                throw new CommandException(this.func_71518_a(sender), new Object[0]);
            }
            World world = sender.func_130014_f_();
            Entity entity = sender.func_174793_f();
            File configDir = new File("config");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            if (!(rankDir = new File(configDir, "minewache/mw-ranks")).exists()) {
                rankDir.mkdirs();
            }
            if (!(jobDir = new File(rankDir, "ranks")).exists()) {
                jobDir.mkdirs();
            }
            File rankConfig = new File(rankDir, "mw-ranks.cfg");
            if (args[0].equalsIgnoreCase("create")) {
                if (args.length < 2) {
                    throw new CommandException(Dateiverwaltung.warning + "/job create <name>", new Object[0]);
                }
                Configuration config = new Configuration(rankConfig);
                config.load();
                String jobName = args[1];
                if (config.hasKey("jobs", jobName)) {
                    throw new CommandException(Dateiverwaltung.warning + "Job with name '" + jobName + "' already exists!", new Object[0]);
                }
                config.get("jobs", jobName, "");
                if (args.length > 2) {
                    for (int i = 2; i < args.length; ++i) {
                        config.get("jobs", jobName, "").setValue(config.get("jobs", jobName, "").getString() + args[i] + "\n");
                    }
                }
                config.save();
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Successfully created job '" + jobName + "'."));
                this.createJobFile(jobDir, jobName);
                return;
            }
            if (args[0].equalsIgnoreCase("delete")) {
                if (args.length < 2) {
                    throw new CommandException("/job delete <name>", new Object[0]);
                }
                Configuration config = new Configuration(rankConfig);
                config.load();
                String jobName = args[1];
                if (!config.hasKey("jobs", jobName)) {
                    throw new CommandException(Dateiverwaltung.warning + "Job mit dem Namen '" + jobName + "' existiert nicht!", new Object[0]);
                }
                this.jobToDelete = jobName;
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Sind Sie sicher, dass Sie die Jobdatei '" + jobName + "' l\ufffdschen m\ufffdchten? Diese Aktion kann nicht r\ufffdckg\ufffdngig gemacht werden. Geben Sie /job dconfirm ein, um zu best\ufffdtigen."));
                return;
            }
            if (args[0].equalsIgnoreCase("setblock")) {
                Vec3d end;
                if (!(sender instanceof EntityPlayerMP)) return;
                EntityPlayerMP player = (EntityPlayerMP)sender;
                Vec3d start = player.func_174824_e(1.0f);
                RayTraceResult result = player.field_70170_p.func_147447_a(start, end = start.func_72441_c(player.func_70676_i((float)1.0f).field_72450_a * 5.0, player.func_70676_i((float)1.0f).field_72448_b * 5.0, player.func_70676_i((float)1.0f).field_72449_c * 5.0), false, false, true);
                if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                    BlockPos blockPos = result.func_178782_a();
                    if (world.func_180495_p(blockPos).func_177230_c() == BlockJobBlock.block.func_176223_P().func_177230_c()) {
                        if (args.length >= 1) {
                            if (!world.field_72995_K) {
                                TileEntity tileEntity = world.func_175625_s(blockPos);
                                IBlockState blockState = world.func_180495_p(blockPos);
                                if (tileEntity != null) {
                                    if (args.length >= 2) {
                                        tileEntity.getTileData().func_74778_a("item1", args[1]);
                                    }
                                    if (args.length >= 3) {
                                        tileEntity.getTileData().func_74778_a("item2", args[2]);
                                    }
                                    if (args.length >= 4) {
                                        tileEntity.getTileData().func_74778_a("item3", args[3]);
                                    }
                                    tileEntity.getTileData().func_74757_a("active", true);
                                }
                                world.func_184138_a(blockPos, blockState, blockState, 3);
                            }
                            sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Der Job Block wurde aktiviert!"));
                            return;
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Der Job Block wurde aktiviert, jedoch wurden nicht alle Argumente angegeben."));
                        }
                        return;
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Du musst auf den Job Block schauen!"));
                    }
                    return;
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Du musst auf einen Block schauen!"));
                }
                return;
            }
            if (args[0].equalsIgnoreCase("addrank")) {
                if (args.length != 4) {
                    throw new CommandException("/job addrank <jobname> <rankname> <playername>", new Object[0]);
                }
                String jobName = args[1];
                String rankName = args[2];
                String playerName = args[3];
                EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
                if (player == null) {
                    throw new CommandException(Dateiverwaltung.warning + "Player '" + playerName + "' not found.", new Object[0]);
                }
                boolean hasJobTag = false;
                for (String tag : player.func_184216_O()) {
                    if (!tag.startsWith("Job_")) continue;
                    hasJobTag = true;
                    break;
                }
                if (hasJobTag) {
                    throw new CommandException(Dateiverwaltung.warning + "Player '" + playerName + "' already has a job tag assigned.", new Object[0]);
                }
                String tag = "Job_" + jobName + "_" + rankName;
                player.func_184211_a(tag);
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Tag '" + tag + "' successfully added to player '" + playerName + "'."));
                return;
            }
            if (args[0].equalsIgnoreCase("removerank")) {
                if (args.length != 2) {
                    throw new CommandException(Dateiverwaltung.warning + "/job removerank <playername>", new Object[0]);
                }
                String playerName = args[1];
                EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
                if (player == null) {
                    throw new CommandException(Dateiverwaltung.warning + "Player '" + playerName + "' not found.", new Object[0]);
                }
                ArrayList<String> removedJobTags = new ArrayList<String>();
                for (String tag : player.func_184216_O()) {
                    if (!tag.startsWith("Job_")) continue;
                    removedJobTags.add(tag);
                    player.func_184197_b(tag);
                }
                if (!removedJobTags.isEmpty()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Removed job tags from player '" + playerName + "': " + String.join((CharSequence)", ", removedJobTags)));
                    return;
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "No job tags found for player '" + playerName + "'."));
                }
                return;
            }
            if (args[0].equalsIgnoreCase("dconfirm")) {
                if (this.jobToDelete.isEmpty()) throw new CommandException(Dateiverwaltung.warning + "Kein Job f\ufffdr die L\ufffdschung ausgew\ufffdhlt.", new Object[0]);
                Configuration config = new Configuration(rankConfig);
                config.load();
                this.deleteJobFile(jobDir, this.jobToDelete, sender);
                config.getCategory("jobs").remove((Object)this.jobToDelete);
                config.save();
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Job '" + this.jobToDelete + "' erfolgreich gel\ufffdscht."));
                this.jobToDelete = "";
                return;
            }
            if (args[0].equalsIgnoreCase("createrank")) {
                if (args.length != 4) {
                    throw new CommandException(Dateiverwaltung.warning + "/job createrank <jobname> <rankname> <geld>", new Object[0]);
                }
                String jobName = args[1];
                String rankName = args[2];
                String geld = args[3];
                File jobDird = new File(rankDir, "ranks");
                File jobFile = new File(jobDird, jobName + ".txt");
                if (!jobFile.exists()) {
                    throw new CommandException(Dateiverwaltung.warning + "Job file for '" + jobName + "' does not exist.", new Object[0]);
                }
                try {
                    double amount = Double.parseDouble(geld);
                    if (amount <= 0.0) {
                        throw new CommandException(Dateiverwaltung.warning + "Invalid amount. Please enter a positive number.", new Object[0]);
                    }
                }
                catch (NumberFormatException e) {
                    throw new CommandException(Dateiverwaltung.warning + "Invalid amount. Please enter a valid number.", new Object[0]);
                }
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(jobFile));
                    while ((line = reader.readLine()) != null) {
                        String[] parts = line.split(";");
                        if (parts.length <= 0 || !parts[0].equals(rankName)) continue;
                        reader.close();
                        throw new CommandException(Dateiverwaltung.warning + "Rank '" + rankName + "' already exists in job '" + jobName + "'.", new Object[0]);
                    }
                    reader.close();
                    FileWriter writer = new FileWriter(jobFile, true);
                    writer.write(rankName + ";" + geld + "\n");
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Successfully added rank '" + rankName + "' to job '" + jobName + "'."));
                return;
            }
            if (args[0].equalsIgnoreCase("deleterank")) {
                if (args.length != 3) {
                    throw new CommandException(Dateiverwaltung.warning + "/job deleterank <jobname> <rankname>", new Object[0]);
                }
                String jobName = args[1];
                String rankName = args[2];
                File jobDird = new File(rankDir, "ranks");
                File jobFile = new File(jobDird, jobName + ".txt");
                if (!jobFile.exists()) {
                    throw new CommandException(Dateiverwaltung.warning + "Job file for '" + jobName + "' does not exist.", new Object[0]);
                }
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(jobFile));
                    ArrayList<String> lines = new ArrayList<String>();
                    boolean found = false;
                    while ((line = reader.readLine()) != null) {
                        String[] parts = line.split(";");
                        if (parts.length > 0 && parts[0].equals(rankName)) {
                            found = true;
                            continue;
                        }
                        lines.add(line);
                    }
                    reader.close();
                    if (!found) {
                        throw new CommandException(Dateiverwaltung.warning + "Rank '" + rankName + "' does not exist in job '" + jobName + "'.", new Object[0]);
                    }
                    FileWriter writer = new FileWriter(jobFile, false);
                    for (String l : lines) {
                        writer.write(l + "\n");
                    }
                    writer.close();
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Successfully removed rank '" + rankName + "' from job '" + jobName + "'."));
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            } else if (args[0].equalsIgnoreCase("currentjob")) {
                if (args.length != 1) {
                    throw new CommandException(Dateiverwaltung.warning + "/job currentjob", new Object[0]);
                }
                EntityPlayer player = (EntityPlayer)sender;
                String currentJob = this.getCurrentJob(player);
                if (!currentJob.isEmpty()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.standard + "Your current job is: " + currentJob));
                    return;
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "You currently don't have any job."));
                }
                return;
            } else {
                if (!args[0].equalsIgnoreCase("ranklist")) throw new CommandException(this.func_71518_a(sender), new Object[0]);
                if (args.length != 2) {
                    throw new CommandException(Dateiverwaltung.warning + "/job ranklist <jobname>", new Object[0]);
                }
                File jobDird = new File(rankDir, "ranks");
                String jobName = args[1];
                File jobFile = new File(jobDird, jobName + ".txt");
                if (!jobFile.exists()) {
                    throw new CommandException(Dateiverwaltung.warning + "Job file for '" + jobName + "' does not exist.", new Object[0]);
                }
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(jobFile));
                    StringBuilder rankList = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        String[] parts = line.split(";");
                        if (parts.length < 2) continue;
                        rankList.append(parts[0]).append(": ").append(parts[1]).append("\n");
                    }
                    reader.close();
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.standard + "Ranks for job '" + jobName + "':\n" + rankList));
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void createJobFile(File directory, String jobName) {
            try {
                File jobFile = new File(directory, jobName + ".txt");
                if (!jobFile.exists()) {
                    jobFile.createNewFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private String getCurrentJob(EntityPlayer player) {
            String currentJob = "";
            for (String tag : player.func_184216_O()) {
                if (!tag.startsWith("Job_")) continue;
                currentJob = tag.substring(tag.indexOf("_") + 1, tag.lastIndexOf("_"));
                break;
            }
            return currentJob;
        }

        private void deleteJobFile(File directory, String jobName, ICommandSender sender) throws CommandException {
            File jobFile = new File(directory, jobName + ".txt");
            if (jobFile.exists()) {
                jobFile.delete();
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Job file '" + jobName + "' does not exist."));
            }
        }
    }
}

