/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandKit
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandKit(ElementsMinewacheRolePlayMod instance) {
        super(instance, 250);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    implements ICommand {
        String standardFarbe = Dateiverwaltung.standard;
        String warningFarbe = Dateiverwaltung.warning;
        String sucessFarbe = Dateiverwaltung.sucess;
        String kitnameFarbe = Dateiverwaltung.kitname;
        String playernameFarbe = Dateiverwaltung.playername;
        String sendernameFarbe = Dateiverwaltung.sendername;
        String errorFarbe = Dateiverwaltung.error;
        private ICommandSender sender;

        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, "minewachemod.command.kit");
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        private File getKitInfoFile(MinecraftServer server) {
            File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
            File minewachemodFolder = new File(worldFolder, "Minewachemod");
            if (!minewachemodFolder.exists()) {
                minewachemodFolder.mkdir();
            }
            return new File(minewachemodFolder, "KITS.kitinfo");
        }

        private NBTTagCompound readNBTDataFromFile(MinecraftServer server, String kitName) {
            NBTTagCompound nbtData = new NBTTagCompound();
            try {
                File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
                File file = new File(worldFolder, "KITS.kitinfo");
                if (!file.exists()) {
                    return nbtData;
                }
                Scanner scanner = new Scanner(file);
                boolean foundKit = false;
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith(kitName + ";")) continue;
                    foundKit = true;
                    while (scanner.hasNextLine() && !(line = scanner.nextLine().trim()).equals("{")) {
                    }
                    StringBuilder nbtDataBuilder = new StringBuilder();
                    while (scanner.hasNextLine() && !(line = scanner.nextLine().trim()).equals("}")) {
                        nbtDataBuilder.append(line);
                    }
                    scanner.close();
                    nbtData = new NBTTagCompound();
                    nbtData.func_74778_a("NBTData", nbtDataBuilder.toString());
                    return nbtData;
                }
                scanner.close();
                if (!foundKit) {
                    this.sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Das Kit " + this.kitnameFarbe + kitName + this.standardFarbe + " wurde nicht gefunden."));
                }
            }
            catch (IOException e) {
                this.sender.func_145747_a((ITextComponent)new TextComponentString(this.errorFarbe + "Fehler beim Lesen der Kit-Daten."));
                e.printStackTrace();
            }
            return nbtData;
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            ArrayList<String> completions = new ArrayList<String>();
            ArrayList<String> suggestions = new ArrayList<String>();
            if (args.length == 1) {
                suggestions.add("add");
                suggestions.add("remove");
                suggestions.add("list");
                suggestions.add("give");
            } else if (args.length == 2 && args[0].equalsIgnoreCase("add")) {
                suggestions.addAll(this.getExistingKitNames(server));
            } else if (args.length == 2 && args[0].equalsIgnoreCase("list")) {
                suggestions.addAll(this.getExistingKitNames(server));
            } else if (args.length == 2 && args[0].equalsIgnoreCase("remove")) {
                suggestions.addAll(this.getExistingKitNames(server));
            } else if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
                suggestions.addAll(this.getExistingKitNames(server));
            }
            for (String suggestion : suggestions) {
                if (!suggestion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                completions.add(suggestion);
            }
            return completions;
        }

        private List<String> getOnlinePlayerNames(MinecraftServer server) {
            ArrayList<String> playerNames = new ArrayList<String>();
            for (EntityPlayer player : server.func_184103_al().func_181057_v()) {
                playerNames.add(player.func_70005_c_());
            }
            return playerNames;
        }

        private List<String> getExistingKitNames(MinecraftServer server) {
            ArrayList<String> kitNames = new ArrayList<String>();
            try {
                File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
                File file = this.getKitInfoFile(server);
                if (file.exists()) {
                    Scanner scanner = new Scanner(file);
                    while (scanner.hasNextLine()) {
                        String kitName;
                        String line = scanner.nextLine().trim();
                        if (!line.contains(";") || (kitName = line.split(";")[0].trim()).isEmpty() || kitName.contains(" ")) continue;
                        kitNames.add(kitName);
                    }
                    scanner.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return kitNames;
        }

        public boolean func_82358_a(String[] string, int index) {
            return true;
        }

        public String func_71517_b() {
            return "kit";
        }

        public String func_71518_a(ICommandSender var1) {
            return "/kit add <kitname>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] cmd) {
            this.sender = sender;
            if (cmd.length >= 2) {
                if (cmd[0].equalsIgnoreCase("add")) {
                    String kitName = cmd[1];
                    if (this.kitExistsInFile(server, kitName)) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Das Kit " + this.kitnameFarbe + kitName + this.errorFarbe + " existiert bereits."));
                    } else {
                        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                        if (sender instanceof EntityPlayer) {
                            EntityPlayer player = (EntityPlayer)sender;
                            for (int i = 0; i < 9; ++i) {
                                ItemStack itemStack = player.field_71071_by.func_70301_a(i);
                                if (itemStack.func_190926_b()) continue;
                                items.add(itemStack);
                            }
                        }
                        this.addKitToFile(server, kitName, items);
                    }
                } else if (cmd[0].equalsIgnoreCase("list")) {
                    String kitName = cmd[1];
                    this.listKitData(server, kitName);
                } else if (cmd[0].equalsIgnoreCase("remove")) {
                    String kitName = cmd[1];
                    this.removeKit(server, kitName);
                } else if (cmd[0].equalsIgnoreCase("give")) {
                    String playerName = cmd[1];
                    String kitName = cmd[2];
                    this.giveKitToPlayer(server, sender, playerName, kitName);
                }
            }
        }

        private void giveKitToPlayer(MinecraftServer server, ICommandSender sender, String playerName, String kitName) {
            EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
            if (player != null) {
                int requiredSlots;
                List<ItemStack> kitItems = this.getKitItems(server, kitName);
                int availableSlots = this.countAvailableInventorySlots((EntityPlayer)player);
                if (availableSlots >= (requiredSlots = this.calculateRequiredSlotsFromKitSlots(server, kitName))) {
                    for (ItemStack itemStack : kitItems) {
                        ItemStack itemCopy = itemStack.func_77946_l();
                        if (itemStack.func_77942_o()) {
                            NBTTagCompound itemNBT = itemStack.func_77978_p();
                            itemCopy.func_77982_d(itemNBT.func_74737_b());
                        }
                        player.field_71071_by.func_70441_a(itemCopy);
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Das Kit " + this.kitnameFarbe + kitName + this.standardFarbe + " wurde dem Spieler " + this.playernameFarbe + playerName + this.standardFarbe + " gegeben."));
                } else {
                    int additionalSlotsNeeded = requiredSlots - availableSlots;
                    sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Der Spieler " + this.playernameFarbe + playerName + this.standardFarbe + " hat" + this.warningFarbe + " nicht gen\ufffdgend Platz" + this.standardFarbe + "im Inventar f\ufffdr dieses Kit."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Er ben\ufffdtigt insgesamt " + this.warningFarbe + requiredSlots + this.standardFarbe + " Slots, um das Kit zu erhalten."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Er muss noch " + this.sucessFarbe + additionalSlotsNeeded + this.standardFarbe + " zus\ufffdtzliche Slots frei machen."));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Der Spieler " + this.playernameFarbe + playerName + this.standardFarbe + " konnte nicht gefunden werden."));
            }
        }

        private int countAvailableInventorySlots(EntityPlayer player) {
            int availableSlots = 0;
            for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                if (!itemStack.func_190926_b()) continue;
                ++availableSlots;
            }
            return availableSlots;
        }

        private int calculateRequiredSlotsFromKitSlots(MinecraftServer server, String kitName) {
            int requiredSlots = 0;
            try {
                File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
                File file = this.getKitInfoFile(server);
                if (!file.exists()) {
                    return requiredSlots;
                }
                Scanner scanner = new Scanner(file);
                boolean foundKit = false;
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith(kitName + ";")) continue;
                    foundKit = true;
                    int lineCount = 0;
                    while (scanner.hasNextLine() && !(line = scanner.nextLine().trim()).equals("}")) {
                        ++lineCount;
                    }
                    requiredSlots = lineCount;
                    break;
                }
                scanner.close();
                if (!foundKit) {
                    this.sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Das Kit " + this.kitnameFarbe + kitName + this.standardFarbe + " wurde nicht gefunden."));
                }
            }
            catch (IOException e) {
                this.sender.func_145747_a((ITextComponent)new TextComponentString(this.errorFarbe + "Fehler beim Lesen der Kit-Daten."));
                e.printStackTrace();
            }
            return requiredSlots;
        }

        private List<Integer> getKitSlots(MinecraftServer server, String kitName) {
            ArrayList<Integer> kitSlots = new ArrayList<Integer>();
            try {
                File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
                File file = this.getKitInfoFile(server);
                if (!file.exists()) {
                    return kitSlots;
                }
                Scanner scanner = new Scanner(file);
                boolean foundKit = false;
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith(kitName + ";")) continue;
                    foundKit = true;
                    int lineCount = 0;
                    while (scanner.hasNextLine() && !(line = scanner.nextLine().trim()).equals("}")) {
                        ++lineCount;
                    }
                    for (int i = 0; i < lineCount; ++i) {
                        kitSlots.add(i);
                    }
                }
                scanner.close();
                if (!foundKit) {
                    this.sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Das Kit " + this.kitnameFarbe + kitName + this.standardFarbe + " wurde nicht gefunden."));
                }
            }
            catch (IOException e) {
                this.sender.func_145747_a((ITextComponent)new TextComponentString(this.errorFarbe + "Fehler beim Lesen der Kit-Daten."));
                e.printStackTrace();
            }
            return kitSlots;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private List<ItemStack> getKitItems(MinecraftServer server, String kitName) {
            ArrayList<ItemStack> kitItems = new ArrayList<ItemStack>();
            try {
                File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
                File file = this.getKitInfoFile(server);
                if (!file.exists()) return kitItems;
                Scanner scanner = new Scanner(file);
                boolean foundKit = false;
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith(kitName + ";")) continue;
                    foundKit = true;
                    while (scanner.hasNextLine() && !(line = scanner.nextLine().trim()).equals("}")) {
                        String[] parts = line.split(" ");
                        if (parts.length < 3) continue;
                        String itemName = parts[0];
                        int count = Integer.parseInt(parts[1]);
                        int meta = Integer.parseInt(parts[2]);
                        ItemStack itemStack = new ItemStack(Item.func_111206_d((String)itemName), count, meta);
                        if (parts.length >= 4) {
                            String nbtDataString = parts[3];
                            try {
                                NBTTagCompound nbtData = JsonToNBT.func_180713_a((String)nbtDataString);
                                itemStack.func_77982_d(nbtData);
                            }
                            catch (NBTException e) {
                                e.printStackTrace();
                            }
                        }
                        kitItems.add(itemStack);
                    }
                    break block4;
                }
                scanner.close();
                if (foundKit) return kitItems;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return kitItems;
        }

        private void removeKit(MinecraftServer server, String kitName) {
            try {
                File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
                File file = this.getKitInfoFile(server);
                if (!file.exists()) {
                    this.sender.func_145747_a((ITextComponent)new TextComponentString(this.errorFarbe + "Die Kit-Daten wurden nicht gefunden."));
                    return;
                }
                File tempFile = new File(file.getParent(), "KITS_TEMP.kitinfo");
                Scanner scanner = new Scanner(file);
                FileWriter writer = new FileWriter(tempFile);
                boolean kitRemoved = false;
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (!line.trim().startsWith(kitName + ";")) {
                        writer.write(line + "\n");
                        continue;
                    }
                    kitRemoved = true;
                    while (!line.trim().equals("}")) {
                        line = scanner.nextLine();
                    }
                }
                scanner.close();
                writer.close();
                file.delete();
                tempFile.renameTo(file);
                if (kitRemoved) {
                    this.sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Das Kit " + this.kitnameFarbe + kitName + this.standardFarbe + " wurde erfolgreich entfernt."));
                } else {
                    this.sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Das Kit " + this.kitnameFarbe + kitName + this.warningFarbe + " wurde nicht gefunden."));
                }
            }
            catch (IOException e) {
                this.sender.func_145747_a((ITextComponent)new TextComponentString(this.warningFarbe + "Fehler beim Entfernen des Kits."));
                e.printStackTrace();
            }
        }

        private void listKitData(MinecraftServer server, String kitName) {
            try {
                File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
                File file = this.getKitInfoFile(server);
                if (!file.exists()) {
                    this.sender.func_145747_a((ITextComponent)new TextComponentString(this.errorFarbe + "Die Kit-Daten wurden nicht gefunden."));
                    return;
                }
                Scanner scanner = new Scanner(file);
                boolean foundKit = false;
                while (scanner.hasNextLine()) {
                    String itemLine;
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith(kitName + ";")) continue;
                    foundKit = true;
                    this.sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Kit-Daten f\ufffdr " + this.kitnameFarbe + kitName + this.standardFarbe + ":"));
                    while (scanner.hasNextLine() && !(itemLine = scanner.nextLine().trim()).equals("}")) {
                        this.sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        this.sender.func_145747_a((ITextComponent)new TextComponentString(this.kitnameFarbe + itemLine));
                    }
                    break block2;
                }
                scanner.close();
                if (!foundKit) {
                    this.sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Das Kit " + this.kitnameFarbe + kitName + this.warningFarbe + " wurde nicht gefunden."));
                }
            }
            catch (IOException e) {
                this.sender.func_145747_a((ITextComponent)new TextComponentString(this.errorFarbe + "Fehler beim Lesen der Kit-Daten."));
                e.printStackTrace();
            }
        }

        private void addOrUpdateKitToFile(MinecraftServer server, String kitName, List<String> items) {
            try {
                File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
                File file = this.getKitInfoFile(server);
                FileWriter writer = new FileWriter(file, true);
                if (this.kitExistsInFile(server, kitName)) {
                    this.deleteKitFromFile(server, kitName);
                }
                writer.write(kitName + "; {\n");
                for (String item : items) {
                    writer.write("    " + item + "\n");
                }
                writer.write("}\n");
                writer.close();
                this.sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Kit " + this.kitnameFarbe + kitName + this.standardFarbe + " wurde zur Datei hinzugef\ufffdgt."));
            }
            catch (IOException e) {
                this.sender.func_145747_a((ITextComponent)new TextComponentString(this.errorFarbe + "Fehler beim Hinzuf\ufffdgen des Kits zur Datei."));
                e.printStackTrace();
            }
        }

        private boolean kitExistsInFile(MinecraftServer server, String kitName) {
            try {
                File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
                File file = this.getKitInfoFile(server);
                if (!file.exists()) {
                    return false;
                }
                Scanner scanner = new Scanner(file);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith(kitName + ";")) continue;
                    scanner.close();
                    return true;
                }
                scanner.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }

        private void addKitToFile(MinecraftServer server, String kitName, List<ItemStack> items) {
            try {
                File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
                File file = this.getKitInfoFile(server);
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileWriter writer = new FileWriter(file, true);
                writer.write(kitName + "; {\n");
                for (ItemStack itemStack : items) {
                    if (itemStack.func_190926_b()) continue;
                    String itemName = itemStack.func_77973_b().getRegistryName().toString();
                    int count = itemStack.func_190916_E();
                    int meta = itemStack.func_77960_j();
                    NBTTagCompound nbt = itemStack.func_77978_p();
                    String nbtData = nbt != null ? nbt.toString() : "{}";
                    writer.write("    " + itemName + " " + count + " " + meta + " " + nbtData + "\n");
                }
                writer.write("}\n");
                writer.close();
                this.sender.func_145747_a((ITextComponent)new TextComponentString(this.standardFarbe + "Kit " + this.kitnameFarbe + kitName + this.standardFarbe + " was added to the file."));
            }
            catch (IOException e) {
                this.sender.func_145747_a((ITextComponent)new TextComponentString(this.errorFarbe + "Error while adding the kit to the file."));
                e.printStackTrace();
            }
        }

        private void deleteKitFromFile(MinecraftServer server, String kitName) {
            try {
                File worldFolder = server.func_71218_a(0).func_72860_G().func_75765_b();
                File file = this.getKitInfoFile(server);
                File tempFile = new File(file.getParent(), "KITS_TEMP.kitinfo");
                Scanner scanner = new Scanner(file);
                FileWriter writer = new FileWriter(tempFile);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.trim().startsWith(kitName + ";")) continue;
                    writer.write(line + "\n");
                }
                scanner.close();
                writer.close();
                file.delete();
                tempFile.renameTo(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

