/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandMwcopy
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandMwcopy(ElementsMinewacheRolePlayMod instance) {
        super(instance, 264);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    implements ICommand {
        private static final ConcurrentHashMap<String, String> pendingDeletes = new ConcurrentHashMap();

        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender var1) {
            return true;
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                return this.getListOfStringsMatchingLastWord(args, "copy", "paste", "pull", "delete", "confirmdelete");
            }
            if (args.length == 2 && args[0].equals("paste") || args.length == 2 && args[0].equals("confirmdelete") || args.length == 2 && args[0].equals("delete")) {
                return this.getListOfFilesInDirectory(server);
            }
            return new ArrayList<String>();
        }

        private List<String> getListOfFilesInDirectory(MinecraftServer server) {
            File[] files;
            ArrayList<String> matches = new ArrayList<String>();
            File directory = new File(server.func_71218_a(0).func_72860_G().func_75765_b(), "mwcopydata");
            if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    String fileName = file.getName();
                    matches.add(fileName.substring(0, fileName.lastIndexOf(46)));
                }
            }
            return matches;
        }

        private List<String> getListOfStringsMatchingLastWord(String[] args, String ... possibilities) {
            String lastWord = args[args.length - 1];
            ArrayList<String> matches = new ArrayList<String>();
            for (String possibility : possibilities) {
                if (!possibility.startsWith(lastWord)) continue;
                matches.add(possibility);
            }
            return matches;
        }

        public boolean func_82358_a(String[] string, int index) {
            return true;
        }

        public String func_71517_b() {
            return "mwcopy";
        }

        public String func_71518_a(ICommandSender var1) {
            return "/mwcopy <copy|paste|pull|delete|confirmdelete> <name>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] cmd) throws CommandException {
            if (!(sender instanceof EntityPlayer)) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "This command can only be executed by a player."));
                return;
            }
            EntityPlayer player = (EntityPlayer)sender;
            String playerName = player.func_70005_c_();
            File greenlistFile = new File(server.func_71238_n(), "config/greenlist.protected");
            if (!greenlistFile.exists()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "greenlist.protected file not found. Command execution is denied."));
                return;
            }
            try {
                String line;
                FileReader reader = new FileReader(greenlistFile);
                BufferedReader bufferedReader = new BufferedReader(reader);
                boolean isPlayerAllowed = false;
                while ((line = bufferedReader.readLine()) != null) {
                    if (!(line = line.trim()).equalsIgnoreCase(playerName)) continue;
                    isPlayerAllowed = true;
                    break;
                }
                bufferedReader.close();
                if (!isPlayerAllowed) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "You are not allowed to execute this command."));
                    return;
                }
            }
            catch (IOException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Failed to read greenlist.protected file: " + e.getMessage()));
                return;
            }
            if (cmd.length < 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            String subCommand = cmd[0];
            String name = cmd[1];
            switch (subCommand) {
                case "copy": {
                    this.copyCommand(server, sender, player, name);
                    break;
                }
                case "paste": {
                    this.pasteCommand(server, sender, player, name);
                    break;
                }
                case "pull": {
                    this.pullCommand(server, sender);
                    break;
                }
                case "delete": {
                    this.prepareDeleteCommand(server, sender, player, name);
                    break;
                }
                case "confirmdelete": {
                    this.confirmDeleteCommand(server, sender, player);
                    break;
                }
                default: {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
            }
        }

        private void copyCommand(MinecraftServer server, ICommandSender sender, EntityPlayer player, String name) {
            File file;
            File directory = new File(server.func_71218_a(0).func_72860_G().func_75765_b(), "mwcopydata");
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if ((file = new File(directory, name + ".txt")).exists()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "File '" + name + "' already exists and cannot be overwritten."));
            } else {
                try {
                    file.createNewFile();
                    NBTTagCompound playerData = player.getEntityData().func_74775_l("PlayerPersisted");
                    NBTTagCompound pos1Tag = playerData.func_74775_l("pos1");
                    NBTTagCompound pos2Tag = playerData.func_74775_l("pos2");
                    if (pos1Tag.func_82582_d() || pos2Tag.func_82582_d()) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Error: Both 'pos1' and 'pos2' must be set."));
                        file.delete();
                    } else {
                        FileWriter writer = new FileWriter(file);
                        World world = player.field_70170_p;
                        BlockPos pos1 = new BlockPos(pos1Tag.func_74762_e("x"), pos1Tag.func_74762_e("y"), pos1Tag.func_74762_e("z"));
                        BlockPos pos2 = new BlockPos(pos2Tag.func_74762_e("x"), pos2Tag.func_74762_e("y"), pos2Tag.func_74762_e("z"));
                        int minX = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
                        int maxX = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
                        int minY = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
                        int maxY = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
                        int minZ = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
                        int maxZ = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
                        for (int x = minX; x <= maxX; ++x) {
                            for (int y = minY; y <= maxY; ++y) {
                                for (int z = minZ; z <= maxZ; ++z) {
                                    BlockPos blockPos = new BlockPos(x, y, z);
                                    IBlockState blockState = world.func_180495_p(blockPos);
                                    Block block = blockState.func_177230_c();
                                    String blockName = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
                                    int rotation = block.func_176201_c(blockState);
                                    writer.write(blockName + " " + x + " " + y + " " + z + " " + rotation + "\n");
                                    TileEntity tileEntity = world.func_175625_s(blockPos);
                                    if (tileEntity == null) continue;
                                    NBTTagCompound blockNBT = new NBTTagCompound();
                                    tileEntity.func_189515_b(blockNBT);
                                    writer.write("NBT: " + blockNBT + "\n");
                                }
                            }
                        }
                        List entities = world.func_72872_a(Entity.class, new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1)));
                        for (Entity entity : entities) {
                            NBTTagCompound entityData;
                            if (!entity.func_70039_c(entityData = new NBTTagCompound())) continue;
                            writer.write("ENTITY: " + entityData + "\n");
                        }
                        writer.close();
                        sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Saved block and entity data to file: " + file.getAbsolutePath()));
                    }
                }
                catch (IOException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Failed to create file: " + e.getMessage()));
                }
            }
        }

        private void pasteCommand(MinecraftServer server, ICommandSender sender, EntityPlayer player, String name) {
            File pasteDirectory = new File(server.func_71218_a(0).func_72860_G().func_75765_b(), "mwcopydata");
            File pasteFile = new File(pasteDirectory, name + ".txt");
            if (!pasteFile.exists()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "File '" + name + "' does not exist."));
                return;
            }
            try {
                String line;
                FileReader reader = new FileReader(pasteFile);
                BufferedReader bufferedReader = new BufferedReader(reader);
                BlockPos lastBlockPos = null;
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.startsWith("NBT:")) {
                        if (lastBlockPos == null) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Invalid NBT data without associated block coordinates."));
                            continue;
                        }
                        try {
                            NBTTagCompound tagCompound = JsonToNBT.func_180713_a((String)line.substring(4));
                            TileEntity tileEntity = player.field_70170_p.func_175625_s(lastBlockPos);
                            if (tileEntity == null) {
                                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "No tile entity found at position: " + lastBlockPos));
                                continue;
                            }
                            tileEntity.func_145839_a(tagCompound);
                            tileEntity.func_70296_d();
                            player.field_70170_p.func_184138_a(lastBlockPos, player.field_70170_p.func_180495_p(lastBlockPos), player.field_70170_p.func_180495_p(lastBlockPos), 3);
                        }
                        catch (NBTException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Invalid NBT data in file: " + line));
                        }
                        continue;
                    }
                    if (line.startsWith("ENTITY:")) {
                        try {
                            NBTTagCompound entityTag = JsonToNBT.func_180713_a((String)line.substring(7));
                            Entity entity = EntityList.func_75615_a((NBTTagCompound)entityTag, (World)player.field_70170_p);
                            if (entity == null) continue;
                            player.field_70170_p.func_72838_d(entity);
                        }
                        catch (NBTException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Invalid entity data in file: " + line));
                        }
                        continue;
                    }
                    String[] parts = line.split(" ");
                    if (parts.length != 5) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Invalid line in file: " + line));
                        continue;
                    }
                    String blockName = parts[0];
                    int x = Integer.parseInt(parts[1]);
                    int y = Integer.parseInt(parts[2]);
                    int z = Integer.parseInt(parts[3]);
                    int rotation = Integer.parseInt(parts[4]);
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
                    if (block == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Invalid block in file: " + blockName));
                        continue;
                    }
                    IBlockState blockState = block.func_176203_a(rotation);
                    player.field_70170_p.func_180501_a(pos, blockState, 3);
                    lastBlockPos = pos;
                }
                bufferedReader.close();
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Successfully pasted blocks and entities from file: " + pasteFile.getAbsolutePath()));
            }
            catch (IOException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Failed to read file: " + e.getMessage()));
            }
        }

        private void pullCommand(MinecraftServer server, ICommandSender sender) {
            String repoUrl = "https://github.com/Minewache-Team/mw-map-updates";
            String zipUrl = repoUrl + "/archive/refs/heads/main.zip";
            File targetDirectory = new File(server.func_71218_a(0).func_72860_G().func_75765_b(), "");
            try {
                this.downloadAndExtractTxtFiles(zipUrl, targetDirectory);
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Successfully pulled and extracted .txt files from: " + repoUrl));
            }
            catch (IOException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Failed to pull repository: " + e.getMessage()));
            }
        }

        private void downloadAndExtractTxtFiles(String zipUrl, File targetDirectory) throws IOException {
            if (!targetDirectory.exists()) {
                targetDirectory.mkdirs();
            }
            File zipFile = new File(targetDirectory, "repo.zip");
            try (InputStream in = new URL(zipUrl).openStream();){
                Files.copy(in, zipFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            var5_5 = null;
            try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFile.toPath(), new OpenOption[0]));){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    if (!entry.getName().endsWith(".txt")) continue;
                    File newFile = new File(targetDirectory, entry.getName().replace("mw-map-updates-main", "mwcopydata"));
                    if (!newFile.getParentFile().isDirectory() && !newFile.getParentFile().mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile.getParentFile());
                    }
                    Files.copy(zis, newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            Files.delete(zipFile.toPath());
        }

        private void prepareDeleteCommand(MinecraftServer server, ICommandSender sender, EntityPlayer player, String name) {
            File directory = new File(server.func_71218_a(0).func_72860_G().func_75765_b(), "mwcopydata");
            File file = new File(directory, name + ".txt");
            if (!file.exists()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "File '" + name + "' not found."));
            } else {
                pendingDeletes.put(player.func_110124_au().toString(), name);
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "File '" + name + "' marked for deletion. Type '/mwcopy confirmdelete' to confirm."));
            }
        }

        private void confirmDeleteCommand(MinecraftServer server, ICommandSender sender, EntityPlayer player) {
            String pendingDelete = pendingDeletes.get(player.func_110124_au().toString());
            if (pendingDelete == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "No file pending for deletion."));
            } else {
                File directory = new File(server.func_71218_a(0).func_72860_G().func_75765_b(), "mwcopydata");
                File file = new File(directory, pendingDelete + ".txt");
                if (!file.exists()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "File '" + pendingDelete + "' not found."));
                } else {
                    file.delete();
                    pendingDeletes.remove(player.func_110124_au().toString());
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "File '" + pendingDelete + "' deleted successfully."));
                }
            }
        }
    }
}

