/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandSpawn
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandSpawn(ElementsMinewacheRolePlayMod instance) {
        super(instance, 280);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    extends CommandBase {
        private final String standardFarbe = Dateiverwaltung.standard;
        private final String warningFarbe = Dateiverwaltung.warning;
        private final String errorFarbe = Dateiverwaltung.error;
        private final String successFarbe = Dateiverwaltung.sucess;

        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, "sarosnewblocksmod.command.spawn");
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] string, int index) {
            return false;
        }

        public String func_71517_b() {
            return "spawn";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/spawn";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] cmd) {
            if (cmd.length > 0) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.spawn.invalid_args", this.warningFarbe, new Object[0]);
                return;
            }
            LangNetworkHandler.sendTranslationMessage(sender, "command.spawn.teleport_success", this.standardFarbe, new Object[0]);
            if (sender instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)sender;
                this.sendSpawnData(player, sender);
            }
        }

        private void sendSpawnData(EntityPlayerMP player, ICommandSender sender) {
            block15: {
                try {
                    File worldFolder = sender.func_130014_f_().func_72860_G().func_75765_b();
                    File minewachemodFolder = new File(worldFolder, "Minewachemod");
                    File dataFile = new File(minewachemodFolder, "spawn.spawninfo");
                    if (dataFile.exists()) {
                        try (BufferedReader reader = new BufferedReader(new FileReader(dataFile));){
                            reader.readLine();
                            double x = Double.parseDouble(reader.readLine().substring(2));
                            double y = Double.parseDouble(reader.readLine().substring(2));
                            double z = Double.parseDouble(reader.readLine().substring(2));
                            float yaw = Float.parseFloat(reader.readLine().split(":")[1].trim());
                            float pitch = Float.parseFloat(reader.readLine().split(":")[1].trim());
                            player.field_71135_a.func_147364_a(x, y, z, yaw, pitch);
                            break block15;
                        }
                    }
                    LangNetworkHandler.sendTranslationMessage(sender, "command.spawn.file_not_found", this.errorFarbe, new Object[0]);
                }
                catch (IOException | NumberFormatException e) {
                    e.printStackTrace();
                    LangNetworkHandler.sendTranslationMessage(sender, "command.spawn.error", this.errorFarbe, new Object[0]);
                }
            }
        }
    }
}

