/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.server.command.CommandTreeBase;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandTeam
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandTeam(ElementsMinewacheRolePlayMod instance) {
        super(instance, 259);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTeamBase());
    }

    public static class ListCommand
    implements ICommand {
        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                ArrayList<String> teamCompletions = new ArrayList<String>();
                File teamFolder = new File("config/minewache/mw-teams/");
                File[] teamFiles = teamFolder.listFiles();
                if (teamFiles != null) {
                    String compareString = args[0].toLowerCase();
                    for (File file : teamFiles) {
                        String teamName;
                        if (!file.getName().endsWith(".txt") || !(teamName = file.getName().replace(".txt", "")).toLowerCase().startsWith(compareString)) continue;
                        teamCompletions.add(teamName);
                    }
                }
                return teamCompletions;
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] string, int index) {
            return false;
        }

        public String func_71517_b() {
            return "list";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/team list [team]";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (args.length == 0) {
                File teamFolder = new File("config/minewache/mw-teams/");
                File[] teamFiles = teamFolder.listFiles();
                if (teamFiles != null && teamFiles.length > 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Teams:"));
                    for (File file : teamFiles) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("- " + file.getName().replace(".txt", "")));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("No teams found."));
                }
            } else if (args.length == 1) {
                String teamName = args[0];
                File teamFile = new File("config/minewache/mw-teams/" + teamName + ".txt");
                if (!teamFile.exists()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Team with that name does not exist!"));
                    return;
                }
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(teamFile));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Players in team " + teamName + ":"));
                    while ((line = reader.readLine()) != null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("- " + line.trim()));
                    }
                    reader.close();
                }
                catch (IOException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Failed to read team file."));
                    e.printStackTrace();
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /team list [<team>]"));
            }
        }
    }

    public static class DeleteCommand
    implements ICommand {
        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            File teamFolder;
            File[] teamFiles;
            ArrayList<String> completions = new ArrayList<String>();
            if (args.length == 1 && (teamFiles = (teamFolder = new File("config/minewache/mw-teams/")).listFiles()) != null) {
                for (File file : teamFiles) {
                    if (!file.getName().endsWith(".txt")) continue;
                    completions.add(file.getName().replace(".txt", ""));
                }
            }
            return completions;
        }

        public boolean func_82358_a(String[] string, int index) {
            return true;
        }

        public String func_71517_b() {
            return "delete";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/team delete <name>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (args.length < 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /team delete <name>"));
                return;
            }
            File teamFile = new File("config/minewache/mw-teams/" + args[0] + ".txt");
            if (!teamFile.exists()) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Team with that name does not exist!"));
                return;
            }
            if (teamFile.delete()) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Team deleted successfully!"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Failed to delete team file."));
            }
        }
    }

    public static class RemoveCommand
    implements ICommand {
        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                ArrayList<String> playerCompletions = new ArrayList<String>();
                for (EntityPlayer player : server.func_184103_al().func_181057_v()) {
                    playerCompletions.add(player.func_70005_c_());
                }
                return playerCompletions;
            }
            if (args.length == 2) {
                ArrayList<String> teamCompletions = new ArrayList<String>();
                File teamFolder = new File("config/minewache/mw-teams/");
                File[] teamFiles = teamFolder.listFiles();
                if (teamFiles != null) {
                    String compareString = args[1].toLowerCase();
                    for (File file : teamFiles) {
                        String teamName;
                        if (!file.getName().endsWith(".txt") || !(teamName = file.getName().replace(".txt", "")).toLowerCase().startsWith(compareString)) continue;
                        teamCompletions.add(teamName);
                    }
                }
                return teamCompletions;
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] string, int index) {
            return index == 0;
        }

        public String func_71517_b() {
            return "remove";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/team remove <player> <team>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (args.length < 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /team remove <player> <team>"));
                return;
            }
            String playerName = args[0];
            String teamName = args[1];
            File teamFile = new File("config/minewache/mw-teams/" + teamName + ".txt");
            if (!teamFile.exists()) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Team with that name does not exist!"));
                return;
            }
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(teamFile));
                ArrayList<String> lines = new ArrayList<String>();
                boolean playerFound = false;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().equalsIgnoreCase(playerName)) {
                        playerFound = true;
                        continue;
                    }
                    lines.add(line);
                }
                reader.close();
                if (!playerFound) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Player is not in the team!"));
                    return;
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(teamFile));
                for (String updatedLine : lines) {
                    writer.write(updatedLine);
                    writer.newLine();
                }
                writer.close();
                sender.func_145747_a((ITextComponent)new TextComponentString("Player removed from the team!"));
            }
            catch (IOException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Failed to remove player from the team."));
                e.printStackTrace();
            }
        }
    }

    public static class AddCommand
    implements ICommand {
        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                ArrayList<String> playerCompletions = new ArrayList<String>();
                for (EntityPlayer player : server.func_184103_al().func_181057_v()) {
                    playerCompletions.add(player.func_70005_c_());
                }
                return playerCompletions;
            }
            if (args.length == 2) {
                ArrayList<String> teamCompletions = new ArrayList<String>();
                File teamFolder = new File("config/minewache/mw-teams/");
                File[] teamFiles = teamFolder.listFiles();
                if (teamFiles != null) {
                    String compareString = args[1].toLowerCase();
                    for (File file : teamFiles) {
                        String teamName;
                        if (!file.getName().endsWith(".txt") || !(teamName = file.getName().replace(".txt", "")).toLowerCase().startsWith(compareString)) continue;
                        teamCompletions.add(teamName);
                    }
                }
                return teamCompletions;
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] string, int index) {
            return index == 1;
        }

        public String func_71517_b() {
            return "add";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/team add <player> <team>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (args.length < 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /team add <player> <team>"));
                return;
            }
            String playerName = args[0];
            String teamName = args[1];
            File teamFile = new File("config/minewache/mw-teams/" + teamName + ".txt");
            if (!teamFile.exists()) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Team with that name does not exist!"));
                return;
            }
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(teamFile));
                while ((line = reader.readLine()) != null) {
                    if (!line.trim().equalsIgnoreCase(playerName)) continue;
                    reader.close();
                    sender.func_145747_a((ITextComponent)new TextComponentString("Player is already in the team!"));
                    return;
                }
                reader.close();
                BufferedWriter writer = new BufferedWriter(new FileWriter(teamFile, true));
                writer.write(playerName);
                writer.newLine();
                writer.close();
                sender.func_145747_a((ITextComponent)new TextComponentString("Player added to the team!"));
            }
            catch (IOException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Failed to add player to the team."));
                e.printStackTrace();
            }
        }
    }

    public static class CreateCommand
    implements ICommand {
        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] string, int index) {
            return true;
        }

        public String func_71517_b() {
            return "create";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/team create <name>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (args.length < 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Usage: /team create <name>"));
                return;
            }
            File teamFile = new File("config/minewache/mw-teams/" + args[0] + ".txt");
            if (teamFile.exists()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Team with that name already exists!"));
                return;
            }
            try {
                teamFile.createNewFile();
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Team created successfully!"));
            }
            catch (IOException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Failed to create team file."));
                e.printStackTrace();
            }
        }
    }

    public static class CommandTeamBase
    extends CommandTreeBase {
        public CommandTeamBase() {
            this.addSubcommand(new CreateCommand());
            this.addSubcommand(new DeleteCommand());
            this.addSubcommand(new AddCommand());
            this.addSubcommand(new RemoveCommand());
            this.addSubcommand(new ListCommand());
        }

        public String func_71517_b() {
            return "team";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/team <create|delete|list> [<arguments>]";
        }
    }
}

