/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandTempban
extends ElementsMinewacheRolePlayMod.ModElement {
    private static final Map<UUID, Long> bannedPlayers = new HashMap<UUID, Long>();
    String standardFarbe = Dateiverwaltung.standard;
    String warningFarbe = Dateiverwaltung.warning;
    String errorFarbe = Dateiverwaltung.error;
    String successFarbe = Dateiverwaltung.sucess;
    String playernameFarbe = Dateiverwaltung.playername;
    String sendernameFarbe = Dateiverwaltung.sendername;

    public CommandTempban(ElementsMinewacheRolePlayMod instance) {
        super(instance, 285);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        long currentTime = System.currentTimeMillis();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        bannedPlayers.entrySet().removeIf(entry -> {
            if (currentTime > (Long)entry.getValue()) {
                server.func_184103_al().func_152608_h().func_152684_c((Object)server.func_152358_ax().func_152652_a((UUID)entry.getKey()));
                return true;
            }
            return false;
        });
    }

    public class CommandHandler
    implements ICommand {
        private static final String PERMISSION = "sarosnewblocksmod.command.tempban";

        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, PERMISSION);
        }

        public List<String> func_71514_a() {
            return Collections.singletonList("tempban");
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        public String func_71517_b() {
            return "tempban";
        }

        public String func_71518_a(ICommandSender sender) {
            return new TextComponentTranslation("command.tempban.usage", new Object[0]).func_150254_d();
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 2) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.tempban.no_arguments", CommandTempban.this.warningFarbe, new Object[0]);
                throw new CommandException("Verwendung: /tempban <Spieler> <Zeit>", new Object[0]);
            }
            EntityPlayerMP player = server.func_184103_al().func_152612_a(args[0]);
            if (player == null) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.tempban.player_not_found", CommandTempban.this.errorFarbe, CommandTempban.this.playernameFarbe + args[0]);
                throw new CommandException("Spieler nicht gefunden", new Object[0]);
            }
            long duration = this.parseDuration(args[1]);
            if (duration <= 0L) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.tempban.invalid_time_format", CommandTempban.this.errorFarbe, new Object[0]);
                throw new CommandException("Ung\ufffdltiges Zeitformat", new Object[0]);
            }
            Date banEndDate = new Date(System.currentTimeMillis() + duration);
            UserListBansEntry banEntry = new UserListBansEntry(player.func_146103_bH(), null, sender.func_70005_c_(), banEndDate, "Tempor\ufffdrer Bann");
            server.func_184103_al().func_152608_h().func_152687_a((UserListEntry)banEntry);
            bannedPlayers.put(player.func_110124_au(), System.currentTimeMillis() + duration);
            player.field_71135_a.func_194028_b((ITextComponent)new TextComponentString(new TextComponentTranslation("command.tempban.kicked_message", new Object[]{args[1]}).func_150254_d()));
            LangNetworkHandler.sendTranslationMessage(sender, "command.tempban.banned_player", CommandTempban.this.successFarbe, CommandTempban.this.playernameFarbe + args[0], args[1]);
        }

        private long parseDuration(String time) {
            try {
                if (time.endsWith("s")) {
                    return Long.parseLong(time.substring(0, time.length() - 1)) * 1000L;
                }
                if (time.endsWith("m")) {
                    return Long.parseLong(time.substring(0, time.length() - 1)) * 1000L * 60L;
                }
                if (time.endsWith("h")) {
                    return Long.parseLong(time.substring(0, time.length() - 1)) * 1000L * 60L * 60L;
                }
                if (time.endsWith("w")) {
                    return Long.parseLong(time.substring(0, time.length() - 1)) * 1000L * 60L * 60L * 24L * 7L;
                }
            }
            catch (NumberFormatException e) {
                return -1L;
            }
            return -1L;
        }
    }
}

