/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.config;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class ConfigKamera
extends ElementsMinewacheRolePlayMod.ModElement {
    private static final int defaultRenderDistance = 16;
    public static int currentRenderDistance = 16;
    private static final int defaultFov = 70;
    public static int currentFov = 70;
    private static final float defaultGamma = 1.0f;
    public static float currentGamma = 1.0f;

    public ConfigKamera(ElementsMinewacheRolePlayMod instance) {
        super(instance, 284);
    }

    public static void loadConfigFromFile(File configFile) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(configFile));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Fov = ")) {
                    currentFov = Integer.parseInt(line.substring("Fov = ".length()).trim());
                    continue;
                }
                if (line.startsWith("RenderDistance = ")) {
                    currentRenderDistance = Integer.parseInt(line.substring("RenderDistance = ".length()).trim());
                    continue;
                }
                if (!line.startsWith("Gamma = ")) continue;
                currentGamma = Float.parseFloat(line.substring("Gamma = ".length()).trim());
            }
            reader.close();
            System.out.println("Loaded config values: Fov = " + currentFov + ", Gamma = " + currentGamma + ", Render Distance = " + currentRenderDistance);
        }
        catch (IOException e) {
            System.err.println("Error reading config file: " + configFile.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public static int getCurrentFov() {
        return currentFov;
    }

    public static int getCurrentRenderDistance() {
        return currentRenderDistance;
    }

    public static float getCurrentGamma() {
        return currentGamma;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        File configFile;
        File mwConfigDir;
        File configDir = new File(event.getModConfigurationDirectory(), "minewache");
        if (!configDir.exists()) {
            configDir.mkdirs();
            System.out.println("Created directory: " + configDir.getAbsolutePath());
        }
        if (!(mwConfigDir = new File(configDir, "mw-config")).exists()) {
            mwConfigDir.mkdirs();
            System.out.println("Created directory: " + mwConfigDir.getAbsolutePath());
        }
        if (!(configFile = new File(mwConfigDir, "mw-cam.cfg")).exists()) {
            this.createDefaultConfig(configFile);
        } else {
            ConfigKamera.loadConfigFromFile(configFile);
        }
    }

    private void createDefaultConfig(File configFile) {
        try {
            configFile.createNewFile();
            System.out.println("Created file: " + configFile.getAbsolutePath());
            FileWriter writer = new FileWriter(configFile);
            writer.write("----------------------------------------------\n");
            writer.write("Cam Config\n");
            writer.write("----------------------------------------------\n");
            writer.write("\n");
            writer.write("Fov = 70\n");
            writer.write("Gamma = 1.0\n");
            writer.write("RenderDistance = 16\n");
            writer.close();
            System.out.println("Successfully wrote to file: " + configFile.getAbsolutePath());
            currentFov = 70;
            currentFov = 16;
            currentGamma = 1.0f;
        }
        catch (IOException e) {
            System.err.println("Error creating or writing to file: " + configFile.getAbsolutePath());
            e.printStackTrace();
        }
    }
}

