/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.phone;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class PhoneClientState {
    public static final Map<String, Conversation> conversations = new LinkedHashMap<String, Conversation>();
    public static final Map<String, String> nicknames = new HashMap<String, String>();
    public static final Map<String, Boolean> online = new HashMap<String, Boolean>();
    public static final Map<String, Long> lastSeen = new HashMap<String, Long>();
    public static final Settings settings = new Settings();
    public static final List<PhotoMeta> photos = new ArrayList<PhotoMeta>();
    public static final Map<String, ResourceLocation> photoThumbs = new HashMap<String, ResourceLocation>();

    public static void addIncoming(Message m) {
        Conversation c = conversations.computeIfAbsent(m.group ? m.to : (m.from.equals(PhoneClientState.self()) ? m.to : m.from), id -> {
            Conversation cc = new Conversation();
            cc.id = id;
            cc.group = m.group;
            cc.title = id;
            return cc;
        });
        c.messages.add(m);
        ++c.unread;
    }

    public static void addOutgoing(Message m) {
        String id = m.group ? m.to : m.to;
        Conversation c = conversations.computeIfAbsent(id, k -> {
            Conversation cc = new Conversation();
            cc.id = id;
            cc.group = m.group;
            cc.title = id;
            return cc;
        });
        c.messages.add(m);
    }

    public static void markRead(String convId) {
        Conversation c = conversations.get(convId);
        if (c != null) {
            c.unread = 0;
        }
    }

    public static void setOnline(String player, boolean isOnline) {
        online.put(player, isOnline);
        if (!isOnline) {
            lastSeen.put(player, System.currentTimeMillis());
        }
    }

    public static String self() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g != null ? mc.field_71439_g.func_70005_c_() : "";
    }

    public static ResourceLocation putThumb(String id, BufferedImage img) {
        DynamicTexture dt = new DynamicTexture(img);
        ResourceLocation rl = Minecraft.func_71410_x().func_110434_K().func_110578_a("mwphone_photo_" + id, dt);
        photoThumbs.put(id, rl);
        return rl;
    }

    public static class PhotoMeta {
        public String id;
        public long ts;
        public int w;
        public int h;
        public String name;
    }

    public static class Conversation {
        public String id;
        public boolean group;
        public String title;
        public final List<Message> messages = new ArrayList<Message>();
        public int unread = 0;
    }

    public static class Message {
        public String id;
        public String from;
        public String to;
        public boolean group;
        public long ts;
        public String text;
        public boolean isImage = false;
        public String imageId = null;
        public int imageW = 0;
        public int imageH = 0;
    }

    public static class Settings {
        public boolean darkTheme = true;
        public float scale = 1.0f;
        public boolean sounds = true;
        public String privacy = "everyone";
        public boolean readReceipts = true;
        public String background = "default_dark.png";
        public int cameraSupersample = 2;
    }
}

