/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.phone;

import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneApp;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneBackgrounds;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneIcons;
import de.sarocesch.minewacheroleplaymod.gui.phone.apps.CameraApp;
import de.sarocesch.minewacheroleplaymod.gui.phone.apps.ContactsApp;
import de.sarocesch.minewacheroleplaymod.gui.phone.apps.MessagesApp;
import de.sarocesch.minewacheroleplaymod.gui.phone.apps.SettingsApp;
import de.sarocesch.minewacheroleplaymod.item.ItemIphone;
import de.sarocesch.minewacheroleplaymod.item.ItemSamsung;
import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneRequestSync;
import de.sarocesch.minewacheroleplaymod.util.PhoneDebug;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class PhoneScreen
extends GuiScreen {
    private static final int BASE_PHONE_WIDTH = 170;
    private static final int BASE_PHONE_HEIGHT = 300;
    private final List<PhoneApp> apps = new ArrayList<PhoneApp>();
    private int contentX;
    private int contentY;
    private int contentW;
    private int contentH;
    private int phoneX;
    private int phoneY;
    private int phoneW;
    private int phoneH;
    private int appGridCols = 3;
    private int appGridRows = 2;
    private int appIconPadding = 12;
    private boolean inApp = false;
    private PhoneApp activeApp = null;
    private int navLeftX;
    private int navLeftY;
    private int navLeftW;
    private int navLeftH;
    private int navMidX;
    private int navMidY;
    private int navMidW;
    private int navMidH;
    private int navRightX;
    private int navRightY;
    private int navRightW;
    private int navRightH;
    private long openStart;
    private EnumHand hand = EnumHand.MAIN_HAND;

    public PhoneScreen(EnumHand hand) {
        this.hand = hand != null ? hand : EnumHand.MAIN_HAND;
        MessagesApp msg = new MessagesApp();
        ContactsApp contacts = new ContactsApp();
        SettingsApp settings = new SettingsApp();
        CameraApp camera = new CameraApp();
        this.apps.add(msg);
        this.apps.add(contacts);
        this.apps.add(settings);
        this.apps.add(camera);
    }

    public int getHandIndex() {
        return this.hand == EnumHand.OFF_HAND ? 1 : 0;
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        PhoneDebug.log("[PHONE] PhoneScreen.initGui hand=" + this.hand);
        this.openStart = System.currentTimeMillis();
        int margin = 8;
        float userScale = PhoneClientState.settings.scale;
        this.phoneW = (int)(170.0f * userScale);
        this.phoneH = (int)(300.0f * userScale);
        this.phoneX = this.field_146294_l - this.phoneW - margin;
        this.phoneY = this.field_146295_m - this.phoneH - margin;
        int statusBar = 18;
        int bottomBar = 22;
        this.contentX = this.phoneX + 10;
        this.contentY = this.phoneY + statusBar + 8;
        this.contentW = this.phoneW - 20;
        this.contentH = this.phoneH - statusBar - bottomBar - 16;
        PhoneBackgrounds.ensureDefaults();
        NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneRequestSync(this.getHandIndex()));
    }

    public void func_73876_c() {
        super.func_73876_c();
        EntityPlayerSP p = this.field_146297_k.field_71439_g;
        if (p != null) {
            ItemStack stack;
            ItemStack itemStack = stack = this.hand == EnumHand.OFF_HAND ? p.func_184592_cb() : p.func_184614_ca();
            if (!this.isPhone(stack)) {
                try {
                    String rn = stack != null && !stack.func_190926_b() && stack.func_77973_b().getRegistryName() != null ? stack.func_77973_b().getRegistryName().toString() : "<none>";
                    PhoneDebug.log("[PHONE] Closing PhoneScreen: not holding phone. Held=" + rn + ", hand=" + this.hand);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.field_146297_k.func_147108_a(null);
            }
            this.applyMovementWhileOpen();
        }
    }

    private boolean isPhone(ItemStack s) {
        if (s == null || s.func_190926_b()) {
            return false;
        }
        Item it = s.func_77973_b();
        if (it instanceof ItemIphone.ItemCustom) {
            return true;
        }
        if (it instanceof ItemSamsung.ItemCustom) {
            return true;
        }
        ResourceLocation rl = it.getRegistryName();
        if (rl == null) {
            return false;
        }
        String key = rl.toString();
        if ("saros_new_blocks_mod:iphone".equals(key) || "saros_new_blocks_mod:samsung".equals(key)) {
            return true;
        }
        return key.endsWith(":iphone") || key.endsWith(":samsung");
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.applyMovementWhileOpen();
        float anim = Math.min(1.0f, (float)(System.currentTimeMillis() - this.openStart) / 120.0f);
        float grow = 0.9f + 0.1f * anim;
        float userScale = PhoneClientState.settings.scale;
        float scale = grow * userScale;
        int margin = 8;
        this.phoneW = (int)(170.0f * scale);
        this.phoneH = (int)(300.0f * scale);
        this.phoneX = this.field_146294_l - this.phoneW - margin;
        this.phoneY = this.field_146295_m - this.phoneH - margin;
        int statusBar = 18;
        int bottomBar = 22;
        int preCX = this.phoneX + 10;
        int preCY = this.phoneY + statusBar + 8;
        int preCW = this.phoneW - 20;
        int preCH = this.phoneH - statusBar - bottomBar - 16;
        if (this.inApp && this.activeApp != null) {
            this.activeApp.prePhoneUiDraw(this.field_146297_k, preCX, preCY, preCW, preCH, this.field_146294_l, this.field_146295_m, partialTicks);
        }
        PhoneScreen.func_73734_a((int)(this.phoneX - 4), (int)(this.phoneY - 4), (int)(this.phoneX + this.phoneW + 4), (int)(this.phoneY + this.phoneH + 4), (int)0x66000000);
        boolean dark = PhoneClientState.settings.darkTheme;
        int body = dark ? -15658476 : -789258;
        int body2 = dark ? -15066081 : -1;
        int bar = dark ? -15855855 : -1710101;
        int textColor = dark ? 0xFFFFFF : 0x111111;
        int radius = Math.min(Math.max(10, Math.round(14.0f * scale)), Math.min(this.phoneW, this.phoneH) / 5);
        this.fillRoundedRect(this.phoneX, this.phoneY, this.phoneX + this.phoneW, this.phoneY + this.phoneH, radius, body);
        this.fillRoundedRect(this.phoneX + 1, this.phoneY + 1, this.phoneX + this.phoneW - 1, this.phoneY + this.phoneH - 1, Math.max(0, radius - 1), body2);
        PhoneScreen.func_73734_a((int)this.phoneX, (int)this.phoneY, (int)(this.phoneX + this.phoneW), (int)(this.phoneY + 18), (int)bar);
        PhoneScreen.func_73734_a((int)this.phoneX, (int)(this.phoneY + this.phoneH - 22), (int)(this.phoneX + this.phoneW), (int)(this.phoneY + this.phoneH), (int)bar);
        int barY = this.phoneY + this.phoneH - 22;
        int pad = 6;
        int slotW = (this.phoneW - pad * 4) / 3;
        int slotH = 16;
        int slotY = barY + 3;
        this.navLeftX = this.phoneX + pad;
        this.navLeftY = slotY;
        this.navLeftW = slotW;
        this.navLeftH = slotH;
        this.navMidX = this.navLeftX + slotW + pad;
        this.navMidY = slotY;
        this.navMidW = slotW;
        this.navMidH = slotH;
        this.navRightX = this.navMidX + slotW + pad;
        this.navRightY = slotY;
        this.navRightW = slotW;
        this.navRightH = slotH;
        int btnCol = -12944642;
        PhoneScreen.func_73734_a((int)this.navLeftX, (int)this.navLeftY, (int)(this.navLeftX + this.navLeftW), (int)(this.navLeftY + this.navLeftH), (int)btnCol);
        PhoneScreen.func_73734_a((int)this.navMidX, (int)this.navMidY, (int)(this.navMidX + this.navMidW), (int)(this.navMidY + this.navMidH), (int)btnCol);
        PhoneScreen.func_73734_a((int)this.navRightX, (int)this.navRightY, (int)(this.navRightX + this.navRightW), (int)(this.navRightY + this.navRightH), (int)btnCol);
        int ic = -1;
        int isz = Math.min(12, this.navLeftH - 4);
        this.drawBackIcon(this.navLeftX + this.navLeftW / 2, this.navLeftY + this.navLeftH / 2, isz, ic);
        this.drawHomeIcon(this.navMidX + this.navMidW / 2, this.navMidY + this.navMidH / 2, isz, ic);
        this.drawCloseIcon(this.navRightX + this.navRightW / 2, this.navRightY + this.navRightH / 2, isz, ic);
        this.contentX = preCX;
        this.contentY = preCY;
        this.contentW = preCW;
        this.contentH = preCH;
        PhoneBackgrounds.drawSelected(this.field_146297_k, this.contentX, this.contentY, this.contentW, this.contentH);
        if (!this.inApp) {
            this.drawHome(this.field_146297_k, this.contentX, this.contentY, this.contentW, this.contentH, mouseX, mouseY, partialTicks);
        } else if (this.activeApp != null) {
            this.activeApp.draw(this.field_146297_k, this.contentX, this.contentY, this.contentW, this.contentH, mouseX - this.contentX, mouseY - this.contentY, partialTicks);
        }
    }

    private void drawHome(Minecraft mc, int x, int y, int w, int h, int mouseX, int mouseY, float pt) {
        int total = this.apps.size();
        int cols = w < 200 ? 2 : this.appGridCols;
        int rows = this.appGridRows;
        int cellW = (w - this.appIconPadding * (cols + 1)) / cols;
        int cellH = (h - this.appIconPadding * (rows + 1)) / rows;
        for (int i = 0; i < total && i < cols * rows; ++i) {
            int col = i % cols;
            int row = i / cols;
            int ix = x + this.appIconPadding + col * (cellW + this.appIconPadding);
            int iy = y + this.appIconPadding + row * (cellH + this.appIconPadding);
            int size = Math.min(cellW, cellH);
            PhoneIcons.App appType = PhoneIcons.App.MESSAGES;
            String title = this.apps.get(i).getTitle().toLowerCase();
            if (title.contains("contact")) {
                appType = PhoneIcons.App.CONTACTS;
            } else if (title.contains("setting")) {
                appType = PhoneIcons.App.SETTINGS;
            } else if (title.contains("camera")) {
                appType = PhoneIcons.App.CAMERA;
            }
            int iconSize = Math.min(44, size - 6);
            int iconX = ix + (size - iconSize) / 2;
            int iconY = iy + (size - iconSize) / 2;
            PhoneIcons.draw(mc, appType, iconX, iconY, iconSize);
            if (appType != PhoneIcons.App.MESSAGES) continue;
            int unread = 0;
            for (PhoneClientState.Conversation c : PhoneClientState.conversations.values()) {
                unread += c.unread;
            }
            if (unread <= 0) continue;
            String badge = String.valueOf(unread);
            int bw = 6 + this.field_146289_q.func_78256_a(badge);
            int bx = ix + size - bw - 4;
            int by = iy + 4;
            PhoneScreen.func_73734_a((int)bx, (int)by, (int)(bx + bw), (int)(by + 12), (int)-2087900);
            this.field_146289_q.func_78276_b(badge, bx + 3, by + 3, -1);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        boolean outside;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int x = this.phoneX;
        int y = this.phoneY;
        int w = this.phoneW;
        int h = this.phoneH;
        boolean bl = outside = mouseX < x || mouseX > x + w || mouseY < y || mouseY > y + h;
        if (!(!outside || this.inApp && this.activeApp != null && this.activeApp.capturesOutsideClicks())) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        if (mouseX >= this.navLeftX && mouseX <= this.navLeftX + this.navLeftW && mouseY >= this.navLeftY && mouseY <= this.navLeftY + this.navLeftH) {
            if (this.inApp && this.activeApp != null && !this.activeApp.onBack()) {
                this.closeApp();
            }
            return;
        }
        if (mouseX >= this.navMidX && mouseX <= this.navMidX + this.navMidW && mouseY >= this.navMidY && mouseY <= this.navMidY + this.navMidH) {
            if (this.inApp) {
                this.closeApp();
            }
            return;
        }
        if (mouseX >= this.navRightX && mouseX <= this.navRightX + this.navRightW && mouseY >= this.navRightY && mouseY <= this.navRightY + this.navRightH) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        if (!this.inApp) {
            int cols = this.contentW < 200 ? 2 : this.appGridCols;
            int rows = this.appGridRows;
            int cellW = this.contentW - this.appIconPadding * (cols + 1);
            int cellH = this.contentH - this.appIconPadding * (rows + 1);
            cellW /= cols;
            cellH /= rows;
            for (int i = 0; i < this.apps.size() && i < cols * rows; ++i) {
                int col = i % cols;
                int row = i / cols;
                int ix = this.contentX + this.appIconPadding + col * (cellW + this.appIconPadding);
                int iy = this.contentY + this.appIconPadding + row * (cellH + this.appIconPadding);
                int size = Math.min(cellW, cellH);
                if (mouseX < ix || mouseX > ix + size || mouseY < iy || mouseY > iy + size) continue;
                this.openApp(this.apps.get(i));
                return;
            }
        } else if (this.activeApp != null) {
            this.activeApp.mouseClicked(mouseX - this.contentX, mouseY - this.contentY, mouseButton);
        }
    }

    void openApp(PhoneApp app) {
        this.inApp = true;
        this.activeApp = app;
        app.setHost(this);
        app.onOpen();
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.7f));
    }

    public void backToHome() {
        this.closeApp();
    }

    public void openConversation(String id, boolean group) {
    }

    public void func_146274_d() throws IOException {
        int dWheel;
        super.func_146274_d();
        if (this.inApp && this.activeApp != null && (dWheel = Mouse.getEventDWheel()) != 0) {
            this.activeApp.mouseScrolled(dWheel);
        }
    }

    private void closeApp() {
        if (this.activeApp != null) {
            this.activeApp.onClose();
        }
        this.inApp = false;
        this.activeApp = null;
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.7f));
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.inApp && this.activeApp != null) {
            this.activeApp.keyTyped(typedChar, keyCode);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void fillRoundedRect(int x1, int y1, int x2, int y2, int r, int color) {
        if (r <= 0) {
            PhoneScreen.func_73734_a((int)x1, (int)y1, (int)x2, (int)y2, (int)color);
            return;
        }
        PhoneScreen.func_73734_a((int)(x1 + r), (int)y1, (int)(x2 - r), (int)y2, (int)color);
        PhoneScreen.func_73734_a((int)x1, (int)(y1 + r), (int)(x1 + r), (int)(y2 - r), (int)color);
        PhoneScreen.func_73734_a((int)(x2 - r), (int)(y1 + r), (int)x2, (int)(y2 - r), (int)color);
        for (int i = 0; i < r; ++i) {
            int dy = i;
            int dx = (int)Math.round((double)r - Math.sqrt(r * r - dy * dy));
            PhoneScreen.func_73734_a((int)(x1 + r - dx), (int)(y1 + i), (int)(x1 + r), (int)(y1 + i + 1), (int)color);
            PhoneScreen.func_73734_a((int)(x2 - r), (int)(y1 + i), (int)(x2 - r + dx), (int)(y1 + i + 1), (int)color);
            PhoneScreen.func_73734_a((int)(x1 + r - dx), (int)(y2 - i - 1), (int)(x1 + r), (int)(y2 - i), (int)color);
            PhoneScreen.func_73734_a((int)(x2 - r), (int)(y2 - i - 1), (int)(x2 - r + dx), (int)(y2 - i), (int)color);
        }
    }

    private void drawBackIcon(int cx, int cy, int s, int color) {
        int r = s / 2;
        for (int i = 0; i <= r; ++i) {
            PhoneScreen.func_73734_a((int)(cx - i), (int)(cy - i), (int)(cx - i + 1), (int)(cy - i + 1), (int)color);
            PhoneScreen.func_73734_a((int)(cx - i), (int)(cy + i), (int)(cx - i + 1), (int)(cy + i + 1), (int)color);
        }
    }

    private void drawHomeIcon(int cx, int cy, int s, int color) {
        int r = s / 2;
        this.fillRoundedRect(cx - r, cy - r, cx + r, cy + r, r, color);
    }

    private void drawCloseIcon(int cx, int cy, int s, int color) {
        int r = s / 2;
        for (int i = -r; i <= r; ++i) {
            PhoneScreen.func_73734_a((int)(cx + i), (int)(cy + i), (int)(cx + i + 1), (int)(cy + i + 1), (int)color);
            PhoneScreen.func_73734_a((int)(cx + i), (int)(cy - i), (int)(cx + i + 1), (int)(cy - i + 1), (int)color);
        }
    }

    private void applyMovementWhileOpen() {
        try {
            boolean blocked;
            boolean bl = blocked = this.inApp && this.activeApp != null && this.activeApp.blocksPlayerMovement();
            if (blocked) {
                this.setMoveKeys(false);
                return;
            }
            KeyBinding kbF = this.field_146297_k.field_71474_y.field_74351_w;
            KeyBinding kbB = this.field_146297_k.field_71474_y.field_74368_y;
            KeyBinding kbL = this.field_146297_k.field_71474_y.field_74370_x;
            KeyBinding kbR = this.field_146297_k.field_71474_y.field_74366_z;
            KeyBinding kbJ = this.field_146297_k.field_71474_y.field_74314_A;
            KeyBinding kbSn = this.field_146297_k.field_71474_y.field_74311_E;
            KeyBinding kbSp = this.field_146297_k.field_71474_y.field_151444_V;
            KeyBinding.func_74510_a((int)kbF.func_151463_i(), (boolean)Keyboard.isKeyDown((int)kbF.func_151463_i()));
            KeyBinding.func_74510_a((int)kbB.func_151463_i(), (boolean)Keyboard.isKeyDown((int)kbB.func_151463_i()));
            KeyBinding.func_74510_a((int)kbL.func_151463_i(), (boolean)Keyboard.isKeyDown((int)kbL.func_151463_i()));
            KeyBinding.func_74510_a((int)kbR.func_151463_i(), (boolean)Keyboard.isKeyDown((int)kbR.func_151463_i()));
            KeyBinding.func_74510_a((int)kbJ.func_151463_i(), (boolean)Keyboard.isKeyDown((int)kbJ.func_151463_i()));
            KeyBinding.func_74510_a((int)kbSn.func_151463_i(), (boolean)Keyboard.isKeyDown((int)kbSn.func_151463_i()));
            KeyBinding.func_74510_a((int)kbSp.func_151463_i(), (boolean)Keyboard.isKeyDown((int)kbSp.func_151463_i()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setMoveKeys(boolean down) {
        try {
            KeyBinding kbF = this.field_146297_k.field_71474_y.field_74351_w;
            KeyBinding kbB = this.field_146297_k.field_71474_y.field_74368_y;
            KeyBinding kbL = this.field_146297_k.field_71474_y.field_74370_x;
            KeyBinding kbR = this.field_146297_k.field_71474_y.field_74366_z;
            KeyBinding kbJ = this.field_146297_k.field_71474_y.field_74314_A;
            KeyBinding kbSn = this.field_146297_k.field_71474_y.field_74311_E;
            KeyBinding kbSp = this.field_146297_k.field_71474_y.field_151444_V;
            KeyBinding.func_74510_a((int)kbF.func_151463_i(), (boolean)down);
            KeyBinding.func_74510_a((int)kbB.func_151463_i(), (boolean)down);
            KeyBinding.func_74510_a((int)kbL.func_151463_i(), (boolean)down);
            KeyBinding.func_74510_a((int)kbR.func_151463_i(), (boolean)down);
            KeyBinding.func_74510_a((int)kbJ.func_151463_i(), (boolean)down);
            KeyBinding.func_74510_a((int)kbSn.func_151463_i(), (boolean)down);
            KeyBinding.func_74510_a((int)kbSp.func_151463_i(), (boolean)down);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.setMoveKeys(false);
    }

    private static class SimpleLabelApp
    implements PhoneApp {
        private final String title;

        public SimpleLabelApp(String t) {
            this.title = t;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getIconLabel() {
            return this.title.substring(0, Math.min(4, this.title.length()));
        }

        @Override
        public void draw(Minecraft mc, int x, int y, int width, int height, int mouseX, int mouseY, float partialTicks) {
            Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + 16), (int)-13947341);
            mc.field_71466_p.func_175063_a(this.title, (float)(x + 6), (float)(y + 4), 0xFFFFFF);
        }
    }
}

