/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.phone.apps;

import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneApp;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneBackgrounds;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneScreen;
import de.sarocesch.minewacheroleplaymod.gui.phone.ui.PhoneUi;
import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneUpdateSettings;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SettingsApp
implements PhoneApp {
    private PhoneClientState.Settings S = PhoneClientState.settings;
    private PhoneScreen host;
    private final int headerH = 20;
    private int row = 18;
    private int y1 = 6;
    private int btnW = 124;
    private int btnH = 16;
    private int btnOffsetX = -8;
    private int cachedBtnX;
    private int cachedContentW;
    private boolean showScaleSlider = false;
    private boolean showPrivacyMenu = false;
    private boolean showBackgroundMenu = false;
    private int sliderRelX;
    private int sliderRelY;
    private int sliderRelW;
    private int sliderRelH;
    private int doneRelX;
    private int doneRelY;
    private int doneRelW = 64;
    private int doneRelH = 16;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private final int scrollStep = 14;
    private final int[] btnYs = new int[6];

    @Override
    public String getTitle() {
        return "Settings";
    }

    @Override
    public String getIconLabel() {
        return "SET";
    }

    @Override
    public void setHost(PhoneScreen host) {
        this.host = host;
    }

    @Override
    public void draw(Minecraft mc, int x, int y, int w, int h, int mouseX, int mouseY, float pt) {
        int oh;
        int ow;
        int ox;
        boolean dark = this.S.darkTheme;
        int bg = dark ? -16053234 : -657672;
        Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)bg);
        int headerH = 20;
        int headerCol = dark ? -15592426 : -1;
        Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + headerH), (int)headerCol);
        mc.field_71466_p.func_78276_b("Settings", x + 6, y + 6, dark ? -1 : -15658735);
        int labelX = x + 6;
        int btnX = x + w - this.btnW - 8;
        this.cachedBtnX = w - this.btnW - 8;
        this.cachedContentW = w;
        int yBase = y + this.y1 + headerH - this.scrollOffset;
        int labelColor = dark ? -1 : -15658735;
        int onCol = -14776091;
        int offCol = -9735552;
        int actColTheme = this.S.darkTheme ? onCol : offCol;
        int actColSounds = this.S.sounds ? onCol : offCol;
        int actColRR = this.S.readReceipts ? onCol : offCol;
        int labelH = mc.field_71466_p.field_78288_b;
        int gap = 2;
        int blockGap = 8;
        int base = yBase;
        String themeText = "Theme: " + (this.S.darkTheme ? "Dark" : "Light");
        int tx0 = btnX + (this.btnW - mc.field_71466_p.func_78256_a(themeText)) / 2;
        mc.field_71466_p.func_78276_b(themeText, tx0, base, labelColor);
        int by0 = base + labelH + gap;
        this.btnYs[0] = by0 - y;
        String themeLabel = this.S.darkTheme ? "Dark ON" : "Light OFF";
        this.drawBtn(mc, btnX, by0, themeLabel, actColTheme);
        base = by0 + this.btnH + blockGap;
        String scaleText = "Scale: " + String.format("%.1f", Float.valueOf(this.S.scale));
        int tx1 = btnX + (this.btnW - mc.field_71466_p.func_78256_a(scaleText)) / 2;
        mc.field_71466_p.func_78276_b(scaleText, tx1, base, labelColor);
        int by1 = base + labelH + gap;
        this.btnYs[1] = by1 - y;
        this.drawBtn(mc, btnX, by1, "Scale", -12944642);
        base = by1 + this.btnH + blockGap;
        String soundsText = "Sounds: " + (this.S.sounds ? "On" : "Off");
        int tx2 = btnX + (this.btnW - mc.field_71466_p.func_78256_a(soundsText)) / 2;
        mc.field_71466_p.func_78276_b(soundsText, tx2, base, labelColor);
        int by2 = base + labelH + gap;
        this.btnYs[2] = by2 - y;
        String soundsLabel = this.S.sounds ? "Sounds ON" : "Sounds OFF";
        this.drawBtn(mc, btnX, by2, soundsLabel, actColSounds);
        base = by2 + this.btnH + blockGap;
        String privText = "Privacy";
        int tx3 = btnX + (this.btnW - mc.field_71466_p.func_78256_a(privText)) / 2;
        mc.field_71466_p.func_78276_b(privText, tx3, base, labelColor);
        int by3 = base + labelH + gap;
        this.btnYs[3] = by3 - y;
        this.drawBtn(mc, btnX, by3, "Privacy", -12944642);
        base = by3 + this.btnH + blockGap;
        String bgText = "Background";
        int tx4 = btnX + (this.btnW - mc.field_71466_p.func_78256_a(bgText)) / 2;
        mc.field_71466_p.func_78276_b(bgText, tx4, base, labelColor);
        int by4 = base + labelH + gap;
        this.btnYs[4] = by4 - y;
        this.drawBtn(mc, btnX, by4, "Background: Change", -12944642);
        base = by4 + this.btnH + blockGap;
        String rrText = "Read Receipts: " + (this.S.readReceipts ? "On" : "Off");
        int tx5 = btnX + (this.btnW - mc.field_71466_p.func_78256_a(rrText)) / 2;
        mc.field_71466_p.func_78276_b(rrText, tx5, base, labelColor);
        int by5 = base + labelH + gap;
        this.btnYs[5] = by5 - y;
        String rrLabel = this.S.readReceipts ? "Receipts ON" : "Receipts OFF";
        this.drawBtn(mc, btnX, by5, rrLabel, actColRR);
        int contentEndRelNoScroll = this.btnYs[5] + this.btnH + this.scrollOffset;
        int viewportHeight = Math.max(0, h - (this.y1 + headerH) - 6);
        int scrollTopRel = this.y1 + headerH;
        int contentHeight = Math.max(0, contentEndRelNoScroll - scrollTopRel);
        this.maxScroll = Math.max(0, contentHeight - viewportHeight);
        if (this.scrollOffset > this.maxScroll) {
            this.scrollOffset = this.maxScroll;
        }
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        if (this.showScaleSlider) {
            int sliderW = Math.min(140, w - 20);
            int sliderX = x + (w - sliderW) / 2;
            int sliderY = y + this.btnYs[1] + this.btnH + 8;
            int sliderH = 10;
            this.sliderRelX = sliderX - x;
            this.sliderRelY = sliderY - y;
            this.sliderRelW = sliderW;
            this.sliderRelH = sliderH;
            float t = (this.S.scale - 0.5f) / 1.5f;
            if (t < 0.0f) {
                t = 0.0f;
            }
            if (t > 1.0f) {
                t = 1.0f;
            }
            PhoneUi.drawSlider(mc, sliderX, sliderY, sliderW, sliderH, t, -12632250, -12944642, -1);
            String val = String.format("%.1f", Float.valueOf(this.S.scale));
            mc.field_71466_p.func_78276_b("Scale: " + val, sliderX + sliderW / 2 - 20, sliderY - 10, labelColor);
            int doneW = this.doneRelW;
            int doneH = this.doneRelH;
            int doneX = x + (w - doneW) / 2;
            int doneY = sliderY + sliderH + 8;
            this.doneRelX = doneX - x;
            this.doneRelY = doneY - y;
            PhoneUi.drawButtonRounded(mc, doneX, doneY, doneW, doneH, -14776091, -1, "Done");
        }
        if (this.showPrivacyMenu) {
            List<String> opts = Arrays.asList("everyone", "contacts", "noone");
            ox = x + 6;
            ow = w - 12;
            oh = 14 * opts.size() + 8;
            int oy = y + this.btnYs[3] + this.btnH + 4;
            PhoneUi.fillRoundedRect(ox, oy, ox + ow, oy + oh, 6, dark ? -15066081 : -1);
            int cy = oy + 4;
            for (String opt : opts) {
                mc.field_71466_p.func_78276_b(opt, ox + 8, cy + 2, labelColor);
                cy += 14;
            }
        }
        if (this.showBackgroundMenu) {
            List<String> opts = PhoneBackgrounds.listBackgrounds();
            ox = x + 6;
            ow = w - 12;
            oh = 14 * opts.size() + 8;
            int oy = y + this.btnYs[4] + this.btnH + 4;
            PhoneUi.fillRoundedRect(ox, oy, ox + ow, oy + oh, 6, dark ? -15066081 : -1);
            int cy = oy + 4;
            for (String opt : opts) {
                mc.field_71466_p.func_78276_b(opt, ox + 8, cy + 2, labelColor);
                cy += 14;
            }
        }
    }

    private void drawBtn(Minecraft mc, int ax, int ay, String label, int color) {
        PhoneUi.drawButtonRounded(mc, ax, ay, this.btnW, this.btnH, color, -1, label);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        int itemH;
        int oy;
        int ow;
        int ox;
        List<String> opts;
        int yBase = this.y1 + 20;
        int btnX = this.cachedBtnX;
        if (this.showScaleSlider) {
            if (mouseX >= this.sliderRelX && mouseX <= this.sliderRelX + this.sliderRelW && mouseY >= this.sliderRelY && mouseY <= this.sliderRelY + this.sliderRelH) {
                float t = (float)(mouseX - this.sliderRelX) / (float)Math.max(1, this.sliderRelW);
                if (t < 0.0f) {
                    t = 0.0f;
                }
                if (t > 1.0f) {
                    t = 1.0f;
                }
                float val = 0.5f + t * 1.5f;
                this.S.scale = Math.max(0.5f, Math.min(2.0f, (float)Math.round(val * 10.0f) / 10.0f));
                this.sync();
                return;
            }
            if (mouseX >= this.doneRelX && mouseX <= this.doneRelX + this.doneRelW && mouseY >= this.doneRelY && mouseY <= this.doneRelY + this.doneRelH) {
                this.showScaleSlider = false;
                return;
            }
        }
        if (mouseY >= this.btnYs[0] && mouseY <= this.btnYs[0] + this.btnH && mouseX >= btnX && mouseX <= btnX + this.btnW) {
            this.S.darkTheme = !this.S.darkTheme;
            this.sync();
            return;
        }
        if (mouseY >= this.btnYs[1] && mouseY <= this.btnYs[1] + this.btnH && mouseX >= btnX && mouseX <= btnX + this.btnW) {
            this.showScaleSlider = !this.showScaleSlider;
            return;
        }
        if (mouseY >= this.btnYs[2] && mouseY <= this.btnYs[2] + this.btnH && mouseX >= btnX && mouseX <= btnX + this.btnW) {
            this.S.sounds = !this.S.sounds;
            this.sync();
            return;
        }
        if (mouseY >= this.btnYs[3] && mouseY <= this.btnYs[3] + this.btnH && mouseX >= btnX && mouseX <= btnX + this.btnW) {
            this.showPrivacyMenu = !this.showPrivacyMenu;
            this.showBackgroundMenu = false;
            return;
        }
        if (this.showPrivacyMenu) {
            opts = Arrays.asList("everyone", "contacts", "noone");
            ox = 6;
            ow = Math.max(10, this.cachedContentW - 12);
            oy = this.btnYs[3] + this.btnH + 4;
            itemH = 14;
            if (mouseX >= ox && mouseX <= ox + ow && mouseY >= oy && mouseY <= oy + itemH * opts.size() + 8) {
                int idx = (mouseY - (oy + 4)) / itemH;
                if (idx >= 0 && idx < opts.size()) {
                    this.S.privacy = opts.get(idx);
                    this.sync();
                }
                this.showPrivacyMenu = false;
                return;
            }
        }
        if (mouseY >= this.btnYs[4] && mouseY <= this.btnYs[4] + this.btnH && mouseX >= btnX && mouseX <= btnX + this.btnW) {
            this.showBackgroundMenu = !this.showBackgroundMenu;
            this.showPrivacyMenu = false;
            return;
        }
        if (this.showBackgroundMenu) {
            opts = PhoneBackgrounds.listBackgrounds();
            ox = 6;
            ow = Math.max(10, this.cachedContentW - 12);
            oy = this.btnYs[4] + this.btnH + 4;
            itemH = 14;
            if (mouseX >= ox && mouseX <= ox + ow && mouseY >= oy && mouseY <= oy + itemH * opts.size() + 8) {
                int idx = (mouseY - (oy + 4)) / itemH;
                if (idx >= 0 && idx < opts.size()) {
                    this.S.background = opts.get(idx);
                    this.sync();
                }
                this.showBackgroundMenu = false;
                return;
            }
        }
        if (mouseY >= this.btnYs[5] && mouseY <= this.btnYs[5] + this.btnH && mouseX >= btnX && mouseX <= btnX + this.btnW) {
            this.S.readReceipts = !this.S.readReceipts;
            this.sync();
            return;
        }
    }

    private static String nextPrivacy(String p) {
        if ("everyone".equals(p)) {
            return "contacts";
        }
        if ("contacts".equals(p)) {
            return "noone";
        }
        return "everyone";
    }

    private void sync() {
        int handIndex = this.host != null ? this.host.getHandIndex() : 0;
        NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneUpdateSettings(handIndex, this.S.darkTheme, this.S.scale, this.S.sounds, this.S.privacy, this.S.readReceipts, this.S.background));
    }

    @Override
    public void mouseScrolled(int delta) {
        if (delta == 0) {
            return;
        }
        int step = delta > 0 ? -14 : 14;
        this.scrollOffset += step;
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        if (this.scrollOffset > this.maxScroll) {
            this.scrollOffset = this.maxScroll;
        }
    }
}

