/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.keybinds;

import de.sarocesch.minewacheroleplaymod.keybinds.KeyBindingFlyDown;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.world.GameType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SpectatorKeySwap {
    private static boolean swapped = false;
    private static int origSneakCode = 0;
    private static int origFlyDownCode = 0;
    private static boolean spectatorActive = false;
    private static boolean autoApplied = false;
    private static final String PROPERTIES_FILE = "config" + File.separator + "minewache_spectator_keys.properties";

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new SpectatorKeySwap());
    }

    public static boolean isSpectatorActive() {
        return spectatorActive;
    }

    public static int getOriginalFlyDownKeyCode() {
        return origFlyDownCode;
    }

    public static void resetToOriginal() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71474_y == null) {
            return;
        }
        String username = SpectatorKeySwap.getLocalUsernameSafe();
        if (username == null) {
            return;
        }
        Properties props = SpectatorKeySwap.loadProperties();
        if (props == null) {
            return;
        }
        String keySneak = username + ".origSneak";
        String keyFlyDown = username + ".origFlyDown";
        if (props.containsKey(keySneak) && props.containsKey(keyFlyDown)) {
            try {
                int savedSneak = Integer.parseInt(props.getProperty(keySneak));
                int savedFlyDown = Integer.parseInt(props.getProperty(keyFlyDown));
                KeyBinding sneak = mc.field_71474_y.field_74311_E;
                KeyBinding flyDown = KeyBindingFlyDown.KEY_FLYDOWN;
                if (flyDown == null) {
                    return;
                }
                sneak.func_151462_b(savedSneak);
                flyDown.func_151462_b(savedFlyDown);
                KeyBinding.func_74508_b();
                mc.field_71474_y.func_74303_b();
                origSneakCode = savedSneak;
                origFlyDownCode = savedFlyDown;
                swapped = false;
                autoApplied = false;
                props.remove(keySneak);
                props.remove(keyFlyDown);
                SpectatorKeySwap.saveProperties(props);
            }
            catch (NumberFormatException ex) {
                props.remove(keySneak);
                props.remove(keyFlyDown);
                SpectatorKeySwap.saveProperties(props);
            }
        } else {
            KeyBinding sneak = mc.field_71474_y.field_74311_E;
            KeyBinding flyDown = KeyBindingFlyDown.KEY_FLYDOWN;
            if (flyDown != null && swapped) {
                sneak.func_151462_b(origSneakCode);
                flyDown.func_151462_b(origFlyDownCode);
                KeyBinding.func_74508_b();
                mc.field_71474_y.func_74303_b();
                swapped = false;
                autoApplied = false;
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        boolean isSpectator;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        PlayerControllerMP ctrl = mc.field_71442_b;
        spectatorActive = isSpectator = ctrl != null && ctrl.func_178889_l() == GameType.SPECTATOR || mc.field_71439_g.func_175149_v();
        KeyBinding sneak = mc.field_71474_y.field_74311_E;
        KeyBinding flyDown = KeyBindingFlyDown.KEY_FLYDOWN;
        if (flyDown == null) {
            return;
        }
        if (isSpectator && !swapped) {
            Properties props;
            origSneakCode = sneak.func_151463_i();
            origFlyDownCode = flyDown.func_151463_i();
            String username = SpectatorKeySwap.getLocalUsernameSafe();
            if (username != null && (props = SpectatorKeySwap.loadProperties()) != null) {
                String keySneak = username + ".origSneak";
                String keyFlyDown = username + ".origFlyDown";
                if (!props.containsKey(keySneak) || !props.containsKey(keyFlyDown)) {
                    props.setProperty(keySneak, Integer.toString(origSneakCode));
                    props.setProperty(keyFlyDown, Integer.toString(origFlyDownCode));
                    SpectatorKeySwap.saveProperties(props);
                }
            }
            sneak.func_151462_b(origFlyDownCode);
            flyDown.func_151462_b(origSneakCode);
            KeyBinding.func_74508_b();
            swapped = true;
            SpectatorKeySwap.trySendVanish(mc, true);
        } else if (!isSpectator && swapped) {
            String username = SpectatorKeySwap.getLocalUsernameSafe();
            Properties props = SpectatorKeySwap.loadProperties();
            int savedSneak = origSneakCode;
            int savedFlyDown = origFlyDownCode;
            if (username != null && props != null) {
                String keySneak = username + ".origSneak";
                String keyFlyDown = username + ".origFlyDown";
                if (props.containsKey(keySneak) && props.containsKey(keyFlyDown)) {
                    try {
                        savedSneak = Integer.parseInt(props.getProperty(keySneak));
                        savedFlyDown = Integer.parseInt(props.getProperty(keyFlyDown));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            sneak.func_151462_b(savedSneak);
            flyDown.func_151462_b(savedFlyDown);
            KeyBinding.func_74508_b();
            swapped = false;
            mc.field_71474_y.func_74303_b();
            if (autoApplied) {
                SpectatorKeySwap.trySendVanish(mc, false);
            }
            if (username != null && props != null) {
                props.remove(username + ".origSneak");
                props.remove(username + ".origFlyDown");
                SpectatorKeySwap.saveProperties(props);
            }
        }
    }

    private static void trySendVanish(Minecraft mc, boolean enteringSpectator) {
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        mc.field_71439_g.func_71165_d("/vanish");
        autoApplied = enteringSpectator;
    }

    private static Properties loadProperties() {
        try {
            File file = new File(Minecraft.func_71410_x().field_71412_D, PROPERTIES_FILE);
            Properties props = new Properties();
            if (file.exists()) {
                try (FileInputStream fis = new FileInputStream(file);){
                    props.load(fis);
                }
            } else {
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
            }
            return props;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void saveProperties(Properties props) {
        try {
            File file = new File(Minecraft.func_71410_x().field_71412_D, PROPERTIES_FILE);
            try (FileOutputStream fos = new FileOutputStream(file);){
                props.store(fos, "Minewache SpectatorKeySwap originals");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String getLocalUsernameSafe() {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.func_110432_I() == null) {
                return null;
            }
            return mc.func_110432_I().func_111285_a();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

