/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.navi.core;

import de.sarocesch.minewacheroleplaymod.navi.core.NaviRoadDetector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class NaviPathfinder {
    private NaviPathfinder() {
    }

    public static List<BlockPos> findRoute(World world, BlockPos start, BlockPos goal, int maxNodes) {
        start = NaviPathfinder.sanitize(world, start);
        goal = NaviPathfinder.sanitize(world, goal);
        if (start == null || goal == null) {
            return null;
        }
        PriorityQueue<Node> open = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.f));
        HashMap<BlockPos, Node> all = new HashMap<BlockPos, Node>();
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        Node n0 = new Node(start, null, 0.0, NaviPathfinder.h(start, goal));
        open.add(n0);
        all.put(start, n0);
        int visited = 0;
        while (!open.isEmpty()) {
            Node cur = open.poll();
            if (!closed.add(cur.pos)) continue;
            if (cur.pos.equals((Object)goal)) {
                return NaviPathfinder.reconstruct(cur);
            }
            if (++visited > maxNodes) break;
            for (BlockPos nb : NaviPathfinder.neighbors(world, cur.pos)) {
                if (!NaviRoadDetector.isRoad(world, nb)) continue;
                double tentativeG = cur.g + NaviPathfinder.cost(cur.pos, nb);
                Node seen = (Node)all.get(nb);
                if (seen != null && !(tentativeG < seen.g)) continue;
                Node nxt = new Node(nb, cur, tentativeG, tentativeG + NaviPathfinder.h(nb, goal));
                all.put(nb, nxt);
                open.add(nxt);
            }
        }
        return null;
    }

    private static List<BlockPos> reconstruct(Node cur) {
        ArrayList<BlockPos> path = new ArrayList<BlockPos>();
        Node n = cur;
        while (n != null) {
            path.add(n.pos);
            n = n.parent;
        }
        Collections.reverse(path);
        return path;
    }

    private static double h(BlockPos a, BlockPos b) {
        return (double)(Math.abs(a.func_177958_n() - b.func_177958_n()) + Math.abs(a.func_177952_p() - b.func_177952_p())) + 0.25 * (double)Math.abs(a.func_177956_o() - b.func_177956_o());
    }

    private static double cost(BlockPos a, BlockPos b) {
        return a.func_177956_o() == b.func_177956_o() ? 1.0 : 1.2;
    }

    private static Iterable<BlockPos> neighbors(World w, BlockPos p) {
        return Arrays.asList(p.func_177978_c(), p.func_177968_d(), p.func_177974_f(), p.func_177976_e());
    }

    private static BlockPos sanitize(World w, BlockPos p) {
        if (p == null) {
            return null;
        }
        if (!NaviRoadDetector.isRoad(w, p)) {
            return null;
        }
        return p;
    }

    private static class Node {
        final BlockPos pos;
        final Node parent;
        final double g;
        final double f;

        Node(BlockPos p, Node par, double g, double f) {
            this.pos = p;
            this.parent = par;
            this.g = g;
            this.f = f;
        }
    }
}

