/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class LangNetworkHandler
extends ElementsMinewacheRolePlayMod.ModElement {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("langnetwork");
    private static int packetId = 0;

    public LangNetworkHandler(ElementsMinewacheRolePlayMod instance) {
        super(instance, 393);
    }

    public static void sendTranslationMessage(ICommandSender sender, String key, String color, Object ... params) {
        String translatedMessage = new TextComponentTranslation(key, params).func_150260_c();
        String colorText = color != null && !color.isEmpty() ? color : "";
        TextComponentString message = new TextComponentString(colorText + translatedMessage);
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            INSTANCE.sendTo((IMessage)new TranslationMessage(key, color, params), player);
        } else {
            sender.func_145747_a((ITextComponent)message);
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerPackets();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
    }

    private void registerPackets() {
        INSTANCE.registerMessage(TranslationMessageHandler.class, TranslationMessage.class, packetId++, Side.CLIENT);
    }

    public static class TranslationMessageHandler
    implements IMessageHandler<TranslationMessage, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(TranslationMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                String translatedMessage = message.getMessage() != null && !message.getMessage().isEmpty() ? new TextComponentTranslation(message.getMessage(), message.getParams()).func_150260_c() : "";
                String colorText = message.getColor() != null && !message.getColor().isEmpty() ? message.getColor() : "";
                TextComponentString textComponent = new TextComponentString(colorText + translatedMessage);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)textComponent);
            });
            return null;
        }
    }

    public static class TranslationMessage
    implements IMessage {
        private String message;
        private String color;
        private Object[] params;

        public TranslationMessage() {
        }

        public TranslationMessage(String message, String color, Object ... params) {
            this.message = message;
            this.color = color;
            this.params = params;
        }

        public void fromBytes(ByteBuf buf) {
            int length = buf.readInt();
            this.message = buf.readBytes(length).toString(StandardCharsets.UTF_8);
            length = buf.readInt();
            this.color = buf.readBytes(length).toString(StandardCharsets.UTF_8);
            int paramsLength = buf.readInt();
            this.params = new Object[paramsLength];
            for (int i = 0; i < paramsLength; ++i) {
                length = buf.readInt();
                this.params[i] = buf.readBytes(length).toString(StandardCharsets.UTF_8);
            }
        }

        public void toBytes(ByteBuf buf) {
            byte[] bytes = this.message != null ? this.message.getBytes(StandardCharsets.UTF_8) : new byte[]{};
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
            bytes = this.color != null ? this.color.getBytes(StandardCharsets.UTF_8) : new byte[]{};
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
            buf.writeInt(this.params.length);
            for (Object param : this.params) {
                bytes = param != null ? param.toString().getBytes(StandardCharsets.UTF_8) : new byte[]{};
                buf.writeInt(bytes.length);
                buf.writeBytes(bytes);
            }
        }

        public String getMessage() {
            return this.message;
        }

        public String getColor() {
            return this.color;
        }

        public Object[] getParams() {
            return this.params;
        }
    }
}

