/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network;

import de.sarocesch.minewacheroleplaymod.navi.client.NaviClientState;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketNaviPath
implements IMessage {
    private List<Vec3d> points = new ArrayList<Vec3d>();

    public PacketNaviPath() {
    }

    public PacketNaviPath(List<Vec3d> points) {
        if (points != null) {
            this.points = points;
        }
    }

    public void fromBytes(ByteBuf buf) {
        int n = buf.readInt();
        this.points = new ArrayList<Vec3d>(Math.max(0, n));
        for (int i = 0; i < n; ++i) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            this.points.add(new Vec3d(x, y, z));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.points.size());
        for (Vec3d p : this.points) {
            buf.writeDouble(p.field_72450_a);
            buf.writeDouble(p.field_72448_b);
            buf.writeDouble(p.field_72449_c);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketNaviPath, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketNaviPath message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> NaviClientState.setPath(message.points));
            return null;
        }
    }
}

