/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketPhoneContacts
implements IMessage {
    public Map<String, Boolean> online = new HashMap<String, Boolean>();
    public Map<String, Long> lastSeen = new HashMap<String, Long>();

    public void toBytes(ByteBuf buf) {
        PacketPhoneContacts.writeMapBool(buf, this.online);
        PacketPhoneContacts.writeMapLong(buf, this.lastSeen);
    }

    public void fromBytes(ByteBuf buf) {
        this.online = PacketPhoneContacts.readMapBool(buf);
        this.lastSeen = PacketPhoneContacts.readMapLong(buf);
    }

    private static void writeString(ByteBuf buf, String s) {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(b.length);
        buf.writeBytes(b);
    }

    private static String readString(ByteBuf buf) {
        int len = buf.readInt();
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    private static void writeMapBool(ByteBuf buf, Map<String, Boolean> map) {
        buf.writeInt(map.size());
        for (Map.Entry<String, Boolean> e : map.entrySet()) {
            PacketPhoneContacts.writeString(buf, e.getKey());
            buf.writeBoolean(e.getValue().booleanValue());
        }
    }

    private static Map<String, Boolean> readMapBool(ByteBuf buf) {
        int n = buf.readInt();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (int i = 0; i < n; ++i) {
            map.put(PacketPhoneContacts.readString(buf), buf.readBoolean());
        }
        return map;
    }

    private static void writeMapLong(ByteBuf buf, Map<String, Long> map) {
        buf.writeInt(map.size());
        for (Map.Entry<String, Long> e : map.entrySet()) {
            PacketPhoneContacts.writeString(buf, e.getKey());
            buf.writeLong(e.getValue().longValue());
        }
    }

    private static Map<String, Long> readMapLong(ByteBuf buf) {
        int n = buf.readInt();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i = 0; i < n; ++i) {
            map.put(PacketPhoneContacts.readString(buf), buf.readLong());
        }
        return map;
    }

    public static class Handler
    implements IMessageHandler<PacketPhoneContacts, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketPhoneContacts msg, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                PhoneClientState.online.clear();
                PhoneClientState.online.putAll(msg.online);
                PhoneClientState.lastSeen.clear();
                PhoneClientState.lastSeen.putAll(msg.lastSeen);
            });
            return null;
        }
    }
}

