/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPhoneReceiveImage
implements IMessage {
    public String id;
    public String from;
    public String to;
    public boolean group;
    public long ts;
    public String imageId;
    public String caption;
    public byte[] png;

    public PacketPhoneReceiveImage() {
    }

    public PacketPhoneReceiveImage(String id, String from, String to, boolean group, long ts, String imageId, String caption, byte[] png) {
        this.id = id;
        this.from = from;
        this.to = to;
        this.group = group;
        this.ts = ts;
        this.imageId = imageId;
        this.caption = caption;
        this.png = png;
    }

    public void toBytes(ByteBuf buf) {
        PacketPhoneReceiveImage.writeString(buf, this.id);
        PacketPhoneReceiveImage.writeString(buf, this.from);
        PacketPhoneReceiveImage.writeString(buf, this.to);
        buf.writeBoolean(this.group);
        buf.writeLong(this.ts);
        PacketPhoneReceiveImage.writeString(buf, this.imageId);
        PacketPhoneReceiveImage.writeString(buf, this.caption);
        buf.writeInt(this.png != null ? this.png.length : 0);
        if (this.png != null) {
            buf.writeBytes(this.png);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = PacketPhoneReceiveImage.readString(buf);
        this.from = PacketPhoneReceiveImage.readString(buf);
        this.to = PacketPhoneReceiveImage.readString(buf);
        this.group = buf.readBoolean();
        this.ts = buf.readLong();
        this.imageId = PacketPhoneReceiveImage.readString(buf);
        this.caption = PacketPhoneReceiveImage.readString(buf);
        int n = buf.readInt();
        this.png = new byte[n];
        if (n > 0) {
            buf.readBytes(this.png);
        }
    }

    static void writeString(ByteBuf buf, String s) {
        if (s == null) {
            s = "";
        }
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.writeShort(b.length);
        buf.writeBytes(b);
    }

    static String readString(ByteBuf buf) {
        int l = buf.readUnsignedShort();
        byte[] b = new byte[l];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    public static class Handler
    implements IMessageHandler<PacketPhoneReceiveImage, IMessage> {
        public IMessage onMessage(PacketPhoneReceiveImage msg, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                try {
                    BufferedImage bi;
                    if (msg.png != null && msg.png.length > 0 && (bi = ImageIO.read(new ByteArrayInputStream(msg.png))) != null) {
                        PhoneClientState.putThumb(msg.imageId, bi);
                    }
                }
                catch (Exception bi) {
                    // empty catch block
                }
                PhoneClientState.Message m = new PhoneClientState.Message();
                m.id = msg.id;
                m.from = msg.from;
                m.to = msg.to;
                m.group = msg.group;
                m.ts = msg.ts;
                m.text = msg.caption != null ? msg.caption : "";
                m.isImage = true;
                m.imageId = msg.imageId;
                PhoneClientState.addIncoming(m);
            });
            return null;
        }
    }
}

