/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketPhoneRecentMessages
implements IMessage {
    public List<Msg> list = new ArrayList<Msg>();

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.list.size());
        for (Msg m : this.list) {
            PacketPhoneRecentMessages.writeString(buf, m.id);
            PacketPhoneRecentMessages.writeString(buf, m.from);
            PacketPhoneRecentMessages.writeString(buf, m.to);
            buf.writeBoolean(m.group);
            buf.writeLong(m.ts);
            PacketPhoneRecentMessages.writeString(buf, m.text);
        }
    }

    public void fromBytes(ByteBuf buf) {
        int n = buf.readInt();
        this.list = new ArrayList<Msg>(n);
        for (int i = 0; i < n; ++i) {
            Msg m = new Msg();
            m.id = PacketPhoneRecentMessages.readString(buf);
            m.from = PacketPhoneRecentMessages.readString(buf);
            m.to = PacketPhoneRecentMessages.readString(buf);
            m.group = buf.readBoolean();
            m.ts = buf.readLong();
            m.text = PacketPhoneRecentMessages.readString(buf);
            this.list.add(m);
        }
    }

    private static void writeString(ByteBuf buf, String s) {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(b.length);
        buf.writeBytes(b);
    }

    private static String readString(ByteBuf buf) {
        int len = buf.readInt();
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    public static class Handler
    implements IMessageHandler<PacketPhoneRecentMessages, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketPhoneRecentMessages msg, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                for (Msg rm : msg.list) {
                    PhoneClientState.Message m = new PhoneClientState.Message();
                    m.id = rm.id;
                    m.from = rm.from;
                    m.to = rm.to;
                    m.group = rm.group;
                    m.ts = rm.ts;
                    m.text = rm.text;
                    if (!rm.from.equals(PhoneClientState.self())) {
                        PhoneClientState.addIncoming(m);
                        continue;
                    }
                    PhoneClientState.addOutgoing(m);
                }
            });
            return null;
        }
    }

    public static class Msg {
        public String id;
        public String from;
        public String to;
        public String text;
        public long ts;
        public boolean group;
    }
}

