/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DependencyManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"Minewache-Dependencies");
    public static final boolean HAS_DYNAMX = DependencyManager.hasClass("fr.dynamx.common.contentpack.DynamXObjectLoaders");
    public static final boolean HAS_ACS_GUIS = DependencyManager.hasClass("fr.aym.acsguis.component.GuiFrame", "fr.aym.acsguis.api.ACsGuiApi");
    public static final boolean HAS_MYSQL = DependencyManager.hasClass("com.mysql.cj.jdbc.Driver", "com.mysql.jdbc.Driver");

    private DependencyManager() {
    }

    private static boolean hasClass(String ... classNames) {
        for (String c : classNames) {
            try {
                Class.forName(c, false, DependencyManager.class.getClassLoader());
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable t) {
                return false;
            }
        }
        return false;
    }

    public static void logAvailabilitySummary() {
        if (!HAS_DYNAMX) {
            LOGGER.warn("[Optional] DynamX not found. Vehicle-related features/commands will be disabled.");
        }
        if (!HAS_ACS_GUIS) {
            LOGGER.warn("[Optional] ACs-GUIs not found. ACs-GUIs-based UIs will be disabled/fallback to vanilla.");
        }
        if (!HAS_MYSQL) {
            LOGGER.warn("[Optional] MySQL Connector/J not found. MySQL features will be disabled regardless of config.");
        }
    }
}

