/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.minecraft.client.Minecraft;

public final class PhoneDebug {
    private static Boolean enabledCache = null;

    private PhoneDebug() {
    }

    private static File getFile() {
        try {
            File base = Minecraft.func_71410_x().field_71412_D;
            File dir = new File(base, "config/mw_phone");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return new File(dir, "debug.properties");
        }
        catch (Throwable t) {
            return new File("debug.properties");
        }
    }

    public static boolean enabled() {
        if (enabledCache != null) {
            return enabledCache;
        }
        try {
            File f = PhoneDebug.getFile();
            if (!f.exists()) {
                enabledCache = Boolean.FALSE;
                return false;
            }
            Properties p = new Properties();
            try (FileInputStream fis = new FileInputStream(f);){
                p.load(fis);
            }
            String s = p.getProperty("debug", "false");
            enabledCache = Boolean.parseBoolean(s);
        }
        catch (Throwable t) {
            enabledCache = Boolean.FALSE;
        }
        return enabledCache;
    }

    public static void setEnabled(boolean v) {
        try {
            File f = PhoneDebug.getFile();
            File dir = f.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            Properties p = new Properties();
            p.setProperty("debug", Boolean.toString(v));
            try (FileOutputStream fos = new FileOutputStream(f);){
                p.store(fos, "Minewache Phone Debug");
            }
            enabledCache = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void invalidate() {
        enabledCache = null;
    }

    public static void log(String msg) {
        if (PhoneDebug.enabled()) {
            try {
                System.out.println(msg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

