/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.manatee.mob;

import aquariusplayz.animalgarden.manatee.Registration;
import aquariusplayz.animalgarden.manatee.mob.ModAnimationState;
import aquariusplayz.animalgarden.manatee.mob.controls.ModBodyRotationControl;
import aquariusplayz.animalgarden.manatee.mob.controls.ModSmoothSwimmingLookControl;
import aquariusplayz.animalgarden.manatee.mob.controls.ModSmoothSwimmingMoveControl;
import aquariusplayz.animalgarden.manatee.mob.goals.ModGoToWaterGoal;
import aquariusplayz.animalgarden.manatee.mob.goals.ModMobPathNavigation;
import aquariusplayz.animalgarden.manatee.mob.goals.ModPanicGoal;
import aquariusplayz.animalgarden.manatee.mob.goals.ModRandomSwimmingOrWalkingGoal;
import com.google.common.collect.Iterables;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModMob
extends Animal {
    public final ModAnimationState wink = new ModAnimationState();
    public final ModAnimationState sniffing = new ModAnimationState();
    public final ModAnimationState openMouth = new ModAnimationState();
    public final ModAnimationState lookLeft = new ModAnimationState();
    public final ModAnimationState lookRight = new ModAnimationState();
    public final ModAnimationState lookUp = new ModAnimationState();
    public final ModAnimationState lookDown = new ModAnimationState();
    public final ModAnimationState headTiltLeft = new ModAnimationState();
    public final ModAnimationState headTiltRight = new ModAnimationState();
    public final ModAnimationState eat = new ModAnimationState();
    public final ModAnimationState swimming = new ModAnimationState();
    public final ModAnimationState crawlingOnGround = new ModAnimationState();
    private static final EntityDataAccessor<Integer> ALGAETYPE = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BEHAVIOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int algaeTick = this.random.nextInt(6000) + 6000;
    public int eatTick;

    public ModMob(EntityType<? extends Animal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        if (this.isInWater()) {
            this.moveControl = new ModSmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.02f, true);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 10);
        } else {
            this.moveControl = new MoveControl((Mob)this);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 5);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(BEHAVIOR, (Object)0);
        p_335317_.define(ALGAETYPE, (Object)0);
    }

    public float getWalkTargetValue(BlockPos p_30159_, LevelReader p_30160_) {
        if (p_30160_.getFluidState(p_30159_).is(FluidTags.WATER)) {
            return 10.0f;
        }
        return p_30160_.getPathfindingCostFromLightLevels(p_30159_);
    }

    public void travel(Vec3 p_30218_) {
        if (this.isInWater()) {
            this.moveRelative(0.1f, p_30218_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.7));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(p_30218_);
        }
    }

    protected BodyRotationControl createBodyControl() {
        return new ModBodyRotationControl((Mob)this);
    }

    protected PathNavigation createNavigation(Level p_30171_) {
        return new ModMobPathNavigation(this, p_30171_);
    }

    public int getBehaviorType() {
        return (Integer)this.entityData.get(BEHAVIOR);
    }

    private void setBehaviorType(int p_30398_) {
        this.entityData.set(BEHAVIOR, (Object)p_30398_);
    }

    public int getAlgaeType() {
        return (Integer)this.entityData.get(ALGAETYPE);
    }

    private void setAlgaeType(int p_30398_) {
        this.entityData.set(ALGAETYPE, (Object)p_30398_);
    }

    public void addAdditionalSaveData(ValueOutput p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        p_29422_.putInt("AlgaeType", this.getAlgaeType());
        p_29422_.putInt("BehaviorType", this.getBehaviorType());
        p_29422_.putInt("AlgaeTick", this.algaeTick);
    }

    public void readAdditionalSaveData(ValueInput p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.setAlgaeType(p_29402_.getIntOr("AlgaeType", 0));
        this.setBehaviorType(p_29402_.getIntOr("BehaviorType", 0));
        p_29402_.getInt("AlgaeTick").ifPresent(p_390644_ -> {
            this.algaeTick = p_390644_;
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, (double)0.15f).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.TEMPT_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ModPanicGoal((PathfinderMob)this, 20.0));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.5, p_326986_ -> p_326986_.is(Registration.MANATEE_FOOD), false));
        this.goalSelector.addGoal(3, (Goal)new ModGoToWaterGoal(this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new ModRandomSwimmingOrWalkingGoal((PathfinderMob)this, 1.0, 10));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
    }

    public void aiStep() {
        super.aiStep();
        if (this.isInWater() && !(this.moveControl instanceof ModSmoothSwimmingMoveControl)) {
            this.moveControl = new ModSmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.02f, true);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 10);
        } else if (this.moveControl instanceof ModSmoothSwimmingMoveControl) {
            this.moveControl = new MoveControl((Mob)this);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 5);
        }
        if (this.eatTick > 0) {
            --this.eatTick;
        }
        if (this.level() instanceof ServerLevel && this.isAlive() && !this.isBaby() && this.isInWater() && this.getAlgaeType() == 0 && --this.algaeTick <= 0) {
            int percent = this.getRandom().nextInt(100);
            if (percent == 0) {
                this.setAlgaeType(3);
            } else if (percent <= 20) {
                this.setAlgaeType(2);
            } else {
                this.setAlgaeType(1);
            }
        }
        if (this.level().isClientSide()) {
            if (this.level().random.nextInt(75) == 0 && this.animationEnded(this.wink, 0.4f)) {
                this.wink.start(this.tickCount);
            }
            if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.sniffing, 0.5f)) {
                this.sniffing.start(this.tickCount);
            }
            if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.openMouth, 5.0f) && this.animationEnded(this.eat, 5.0f)) {
                this.openMouth.start(this.tickCount);
            }
            if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.headTiltLeft, 3.0f) && this.animationEnded(this.headTiltRight, 3.0f)) {
                if (this.getRandom().nextInt(2) == 0) {
                    this.headTiltLeft.start(this.tickCount);
                } else {
                    this.headTiltRight.start(this.tickCount);
                }
            }
            if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.lookLeft, 4.0f) && this.animationEnded(this.lookRight, 4.0f) && this.animationEnded(this.lookUp, 4.0f) && this.animationEnded(this.lookDown, 4.0f)) {
                int a = this.level().random.nextInt(4);
                if (a == 0) {
                    this.lookLeft.start(this.tickCount);
                } else if (a == 1) {
                    this.lookRight.start(this.tickCount);
                } else if (a == 2) {
                    this.lookUp.start(this.tickCount);
                } else {
                    this.lookDown.start(this.tickCount);
                }
            }
        }
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.tickCount) > animLength * 1000.0f;
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(1.0);
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return (SoundEvent)Registration.IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_29437_) {
        return (SoundEvent)Registration.IDLE.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)Registration.IDLE.get();
    }

    protected void playSwimSound(float p_30192_) {
        super.playSwimSound(p_30192_ * 1.5f);
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.TURTLE_SWIM;
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.is(Registration.MANATEE_FOOD);
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        ModMob mob = (ModMob)this.getType().create((Level)p_148993_, EntitySpawnReason.BREEDING);
        return mob;
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        if (this.cleanManatee(itemstack)) {
            if (itemstack.isDamageableItem()) {
                itemstack.hurtAndBreak(1, (LivingEntity)p_30412_, p_30413_);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
            this.usePlayerItem(p_30412_, p_30413_, itemstack);
            this.heal(20.0f);
            this.eatTick = 100;
            if (this.animationEnded(this.eat, 3.0f)) {
                this.eat.start(this.tickCount);
            }
        }
        return super.mobInteract(p_30412_, p_30413_);
    }

    public boolean cleanManatee(ItemStack itemstack) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (itemstack.is(Registration.CLEANING_ITEMS) && this.getAlgaeType() > 0) {
                Object object;
                Iterable itemsInTag;
                Object[] list;
                int length;
                Item newitem = null;
                if (this.getAlgaeType() == 1) {
                    Object object2;
                    Iterable itemsInTag2 = BuiltInRegistries.ITEM.getTagOrEmpty(Registration.COMMON_ITEM_DROPS);
                    Object[] list2 = Iterables.toArray((Iterable)itemsInTag2, Object.class);
                    int length2 = list2.length;
                    if (length2 > 0 && (object2 = list2[this.getRandom().nextInt(length2)]) instanceof Holder) {
                        Holder holder = (Holder)object2;
                        newitem = (Item)holder.get();
                    }
                } else if (this.getAlgaeType() == 2) {
                    Object object3;
                    Iterable itemsInTag3 = BuiltInRegistries.ITEM.getTagOrEmpty(Registration.UNCOMMON_ITEM_DROPS);
                    Object[] list3 = Iterables.toArray((Iterable)itemsInTag3, Object.class);
                    int length3 = list3.length;
                    if (length3 > 0 && (object3 = list3[this.getRandom().nextInt(length3)]) instanceof Holder) {
                        Holder holder = (Holder)object3;
                        newitem = (Item)holder.get();
                    }
                } else if (this.getAlgaeType() == 3 && (length = (list = Iterables.toArray((Iterable)(itemsInTag = BuiltInRegistries.ITEM.getTagOrEmpty(Registration.RARE_ITEM_DROPS)), Object.class)).length) > 0 && (object = list[this.getRandom().nextInt(length)]) instanceof Holder) {
                    Holder holder = (Holder)object;
                    newitem = (Item)holder.get();
                }
                if (newitem != null) {
                    BehaviorUtils.throwItem((LivingEntity)this, (ItemStack)new ItemStack(newitem), (Vec3)this.position());
                    this.setAlgaeType(0);
                    this.playSound((SoundEvent)Registration.IDLE.get(), 2.0f, 0.75f);
                    this.algaeTick = this.random.nextInt(6000) + 6000;
                    return true;
                }
            }
        }
        return false;
    }

    public static void registerBehavior(Holder<Item> item) {
        if (item != null) {
            System.out.println("behavior registered: " + String.valueOf(item.get()));
            if (item.is(Registration.CLEANING_ITEMS)) {
                DispenserBlock.registerBehavior((ItemLike)((ItemLike)item.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

                    protected ItemStack execute(BlockSource p_123541_, ItemStack p_123542_) {
                        BlockPos blockpos;
                        ServerLevel serverlevel = p_123541_.level();
                        List list = serverlevel.getEntitiesOfClass(ModMob.class, new AABB(blockpos = p_123541_.pos().relative((Direction)p_123541_.state().getValue((Property)DispenserBlock.FACING))), EntitySelector.NO_SPECTATORS);
                        if (list.isEmpty()) {
                            this.setSuccess(false);
                            return p_123542_;
                        }
                        for (ModMob mob : list) {
                            if (!mob.cleanManatee(p_123542_)) continue;
                            if (p_123542_.isDamageableItem()) {
                                p_123542_.hurtAndBreak(1, serverlevel, null, p_392701_ -> {});
                            }
                            return p_123542_;
                        }
                        this.setSuccess(false);
                        return p_123542_;
                    }
                });
            }
        }
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return true;
    }
}

