/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.manatee.mob;

import aquariusplayz.animalgarden.manatee.mob.MobAnimations;
import aquariusplayz.animalgarden.manatee.mob.ModMob;
import aquariusplayz.animalgarden.manatee.mob.ModMobRenderState;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public class ModMobModel
extends EntityModel<ModMobRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_manatee", (String)"redpanda"), "main");
    public static final ModelLayerLocation BABY_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_manatee", (String)"redpanda_baby"), "main");
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(Set.of("head"));
    private final ModelPart rootz;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart nose;
    private final ModelPart mouth;
    private final ModelPart righteye;
    private final ModelPart lefteye;
    private final ModelPart body;
    private final ModelPart rightFlipper;
    private final ModelPart leftFlipper;
    private final ModelPart body1;
    private final ModelPart body2;
    private final ModelPart body3;
    private final ModelPart body4;
    private final ModelPart flattenedTail;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public ModMobModel(ModelPart root) {
        super(root);
        this.rootz = root.getChild("rootz");
        this.neck = this.rootz.getChild("neck");
        this.head = this.neck.getChild("head");
        this.nose = this.head.getChild("nose");
        this.mouth = this.head.getChild("mouth");
        this.righteye = this.head.getChild("righteye");
        this.lefteye = this.head.getChild("lefteye");
        this.body = this.rootz.getChild("body");
        this.rightFlipper = this.body.getChild("rightFlipper");
        this.leftFlipper = this.body.getChild("leftFlipper");
        this.body1 = this.body.getChild("body1");
        this.body2 = this.body1.getChild("body2");
        this.body3 = this.body2.getChild("body3");
        this.body4 = this.body3.getChild("body4");
        this.flattenedTail = this.body4.getChild("flattenedTail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rootz = partdefinition.addOrReplaceChild("rootz", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)28.0f, (float)0.0f));
        PartDefinition neck = rootz.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(54, 57).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-10.0f, (float)-7.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(76, 61).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(64, 39).addBox(-3.0f, 4.0f, 0.0f, 6.0f, 1.0f, 3.0f, new CubeDeformation(0.01f)).texOffs(0, 32).addBox(-4.0f, -4.0f, -7.0f, 8.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(60, 43).addBox(-3.0f, 4.0f, -5.0f, 6.0f, 1.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-4.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(26, 57).addBox(-5.0f, 3.0f, -3.0f, 10.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 58).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(68, 24).addBox(1.0f, 7.0f, -3.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(68, 28).addBox(-5.0f, 7.0f, -3.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)-7.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(60, 49).addBox(-3.0f, 0.0f, -5.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-4.0f));
        PartDefinition righteye = head.addOrReplaceChild("righteye", CubeListBuilder.create().texOffs(52, 68).addBox(-0.16f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(-0.15f)), PartPose.offset((float)-4.0f, (float)-2.0f, (float)-3.0f));
        PartDefinition lefteye = head.addOrReplaceChild("lefteye", CubeListBuilder.create().texOffs(58, 68).addBox(-1.04f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(-0.15f)), PartPose.offset((float)4.2f, (float)-2.0f, (float)-3.0f));
        PartDefinition body = rootz.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-10.0f, (float)-11.0f));
        PartDefinition rightFlipper = body.addOrReplaceChild("rightFlipper", CubeListBuilder.create().texOffs(0, 64).addBox(-2.0f, -0.25f, -2.5f, 2.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(68, 0).addBox(-2.0f, -0.25f, 1.5f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)2.25f, (float)8.5f, (float)0.0f, (float)0.0f, (float)1.1345f));
        PartDefinition leftFlipper = body.addOrReplaceChild("leftFlipper", CubeListBuilder.create().texOffs(12, 64).addBox(0.0f, -0.25f, -2.5f, 2.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(68, 12).addBox(0.0f, -0.25f, 1.5f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)2.25f, (float)8.5f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        PartDefinition body1 = body.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -4.0f, 0.0f, 12.0f, 10.0f, 22.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body2 = body1.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(30, 43).addBox(-5.0f, -4.0f, 1.0f, 10.0f, 9.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)0.0f, (float)1.0f, (float)20.0f));
        PartDefinition body3 = body2.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(0, 47).addBox(-4.0f, -3.0f, 1.0f, 8.0f, 6.0f, 5.0f, new CubeDeformation(-0.02f)), PartPose.offset((float)0.0f, (float)2.0f, (float)4.0f));
        PartDefinition body4 = body3.addOrReplaceChild("body4", CubeListBuilder.create().texOffs(64, 32).addBox(-3.0f, -2.0f, 0.0f, 6.0f, 4.0f, 3.0f, new CubeDeformation(-0.03f)), PartPose.offset((float)0.0f, (float)1.0f, (float)5.0f));
        PartDefinition flattenedTail = body4.addOrReplaceChild("flattenedTail", CubeListBuilder.create().texOffs(24, 65).addBox(3.98f, -1.02f, 1.96f, 2.0f, 2.0f, 5.0f, new CubeDeformation(-0.01f)).texOffs(26, 50).addBox(3.98f, -1.02f, 6.94f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.01f)).texOffs(38, 65).addBox(-5.98f, -1.02f, 1.96f, 2.0f, 2.0f, 5.0f, new CubeDeformation(-0.01f)).texOffs(26, 47).addBox(-4.98f, -1.02f, 6.94f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.01f)).texOffs(30, 32).addBox(-4.0f, -1.02f, -0.04f, 8.0f, 2.0f, 9.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)0.0f, (float)1.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(ModMobRenderState p_368486_) {
        super.setupAnim((EntityRenderState)p_368486_);
        ModMob mob = p_368486_.entity;
        this.animate(mob.eat, MobAnimations.eat, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headTiltLeft, MobAnimations.headTiltLeft, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headTiltRight, MobAnimations.headTiltRight, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookDown, MobAnimations.lookDown, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookUp, MobAnimations.lookUp, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookRight, MobAnimations.lookRight, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookLeft, MobAnimations.lookLeft, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.openMouth, MobAnimations.openMouth, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.sniffing, MobAnimations.sniffing, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.wink, MobAnimations.wink, p_368486_.ageInTicks, 1.0f);
        if (!mob.isInWater() && mob.onGround()) {
            this.animateWalk(MobAnimations.crawlingOnGround, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, 2.0f, 25.0f);
        } else {
            this.animateWalk(MobAnimations.swimming, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, 6.0f, 25.0f);
        }
    }

    protected void animate(AnimationState p_361867_, AnimationDefinition p_365477_, float p_361961_) {
        this.animate(p_361867_, p_365477_, p_361961_, 1.0f);
    }

    protected void animateWalk(AnimationDefinition p_363127_, float p_364817_, float p_364163_, float p_365350_, float p_365167_) {
        long i = (long)(p_364817_ * 50.0f * p_365350_);
        float f = Math.min(p_364163_ * p_365167_, 1.0f);
        ModMobModel.animate((Model)this, p_363127_, i, f, ANIMATION_VECTOR_CACHE);
    }

    protected void animate(AnimationState p_368871_, AnimationDefinition p_365491_, float p_363110_, float p_368202_) {
        p_368871_.ifStarted(p_368242_ -> ModMobModel.animate((Model)this, p_365491_, (long)((float)p_368242_.getTimeInMillis(p_363110_) * p_368202_), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    protected void applyStatic(AnimationDefinition p_369884_) {
        ModMobModel.animate((Model)this, p_369884_, 0L, 1.0f, ANIMATION_VECTOR_CACHE);
    }

    public static Optional<ModelPart> getAnyDescendantWithName(Model p_362391_, String p_363872_) {
        Stream stream = p_362391_.root().getAllParts().stream();
        return p_363872_.equals("root") ? Optional.of(p_362391_.root()) : stream.filter(p_364767_ -> p_364767_.hasChild(p_363872_)).findFirst().map(p_366385_ -> p_366385_.getChild(p_363872_));
    }

    public static void animate(Model p_362391_, AnimationDefinition p_232321_, long p_232322_, float p_232323_, Vector3f p_253861_) {
        float f = ModMobModel.getElapsedSeconds(p_232321_, p_232322_);
        for (Map.Entry entry : p_232321_.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = ModMobModel.getAnyDescendantWithName(p_362391_, (String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(p_232330_ -> list.forEach(p_288241_ -> {
                Keyframe[] akeyframe = p_288241_.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)akeyframe.length, p_232315_ -> f <= akeyframe[p_232315_].timestamp()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.timestamp();
                float f2 = j != i ? Mth.clamp((float)(f1 / (keyframe1.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.interpolation().apply(p_253861_, f2, akeyframe, i, j, p_232323_);
                p_288241_.target().apply(p_232330_, p_253861_);
            }));
        }
    }

    public static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.looping() ? f % p_232317_.lengthInSeconds() : f;
    }
}

