/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.manatee.mob.controls;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class ModSmoothSwimmingMoveControl
extends MoveControl {
    private static final float FULL_SPEED_TURN_THRESHOLD = 10.0f;
    private static final float STOP_TURN_THRESHOLD = 60.0f;
    private final int maxTurnX;
    private final int maxTurnY;
    private final float inWaterSpeedModifier;
    private final float outsideWaterSpeedModifier;
    private final boolean applyGravity;

    public ModSmoothSwimmingMoveControl(Mob p_148070_, int p_148071_, int p_148072_, float p_148073_, float p_148074_, boolean p_148075_) {
        super(p_148070_);
        this.maxTurnX = p_148071_;
        this.maxTurnY = p_148072_;
        this.inWaterSpeedModifier = p_148073_;
        this.outsideWaterSpeedModifier = p_148074_;
        this.applyGravity = p_148075_;
    }

    public void tick() {
        if (this.applyGravity && this.mob.isInWater()) {
            double d1 = this.wantedY - this.mob.getY();
            if (d1 > this.mob.getY()) {
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.05, 0.0));
            } else {
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        }
        if (this.operation == MoveControl.Operation.MOVE_TO && !this.mob.getNavigation().isDone()) {
            double d2;
            double d1;
            double d0 = this.wantedX - this.mob.getX();
            double d3 = d0 * d0 + (d1 = this.wantedY - this.mob.getY()) * d1 + (d2 = this.wantedZ - this.mob.getZ()) * d2;
            if (d3 < 2.500000277905201E-7) {
                this.mob.setZza(0.0f);
            } else {
                float f = (float)(Mth.atan2((double)d2, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f;
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f, this.maxTurnY));
                this.mob.yBodyRot = this.mob.getYRot();
                this.mob.yHeadRot = this.mob.getYRot();
                float f1 = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
                if (this.mob.isInWater()) {
                    this.mob.setSpeed(f1 * this.inWaterSpeedModifier);
                    double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                    if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                        float f3 = -((float)(Mth.atan2((double)d1, (double)d4) * 180.0 / 3.1415927410125732));
                        f3 = Mth.clamp((float)Mth.wrapDegrees((float)f3), (float)(-this.maxTurnX), (float)this.maxTurnX);
                        this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), f3, 5.0f));
                    }
                    float f6 = Mth.cos((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                    float f4 = Mth.sin((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                    this.mob.zza = f6 * f1;
                    this.mob.yya = -f4 * f1;
                } else {
                    float f5 = Math.abs(Mth.wrapDegrees((float)(this.mob.getYRot() - f)));
                    float f2 = ModSmoothSwimmingMoveControl.getTurningSpeedFactor(f5);
                    this.mob.setSpeed(f1 * this.outsideWaterSpeedModifier * f2);
                }
            }
        } else {
            this.mob.setSpeed(0.0f);
            this.mob.setXxa(0.0f);
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }

    private static float getTurningSpeedFactor(float p_249853_) {
        return 1.0f - Mth.clamp((float)((p_249853_ - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
    }
}

