/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.client;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.client.CellCultureModelWrapper;
import piotro15.symbiont.client.screen.BioformerScreen;
import piotro15.symbiont.client.screen.BioreactorScreen;
import piotro15.symbiont.client.screen.CentrifugeScreen;
import piotro15.symbiont.client.screen.MetabolizerScreen;
import piotro15.symbiont.client.screen.RecombinatorScreen;
import piotro15.symbiont.common.Symbiont;
import piotro15.symbiont.common.genetics.Biotrait;
import piotro15.symbiont.common.genetics.CellType;
import piotro15.symbiont.common.registry.ModDataComponents;
import piotro15.symbiont.common.registry.ModFluids;
import piotro15.symbiont.common.registry.ModItems;
import piotro15.symbiont.common.registry.ModMenuTypes;
import piotro15.symbiont.common.registry.ModRegistries;

@EventBusSubscriber(modid="symbiont", value={Dist.CLIENT})
public class SymbiontClient {
    public static final Map<DeferredHolder<Fluid, FlowingFluid>, IClientFluidTypeExtensions> fluidTypeExtensions = Map.ofEntries(Map.entry(ModFluids.NUTRITIONAL_PASTE, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -28757)), Map.entry(ModFluids.SWEET_PASTE, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -6175233)), Map.entry(ModFluids.PROTEIN_PASTE, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -4889177)), Map.entry(ModFluids.MYOGENIC_BIOMASS, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -3579037)), Map.entry(ModFluids.STICKY_PASTE, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -2968436)), Map.entry(ModFluids.BIOPOLYMER_SOLUTION, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -8388652)), Map.entry(ModFluids.CUPRIC_PASTE, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -2458788)), Map.entry(ModFluids.FERRIC_PASTE, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -7667712)), Map.entry(ModFluids.ENRICHED_CUPRIC_SOLUTION, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -32944)), Map.entry(ModFluids.FERRIC_SOLUTION, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -4767474)), Map.entry(ModFluids.CUPRIC_SOLUTION, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -3248085)), Map.entry(ModFluids.AURIC_SOLUTION, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -10496)), Map.entry(ModFluids.MARINE_EXTRACT, SymbiontClient.createFluidType(Symbiont.id("block/thick_fluid_still"), Symbiont.id("block/thick_fluid_flow"), -14055328)));

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModMenuTypes.BIOREACTOR.get(), BioreactorScreen::new);
        event.register((MenuType)ModMenuTypes.RECOMBINATOR.get(), RecombinatorScreen::new);
        event.register((MenuType)ModMenuTypes.METABOLIZER.get(), MetabolizerScreen::new);
        event.register((MenuType)ModMenuTypes.CENTRIFUGE.get(), CentrifugeScreen::new);
        event.register((MenuType)ModMenuTypes.BIOFORMER.get(), BioformerScreen::new);
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            ResourceLocation cellId = (ResourceLocation)stack.getComponents().get(ModDataComponents.CELL_TYPE.get());
            if (cellId == null) {
                return -1;
            }
            if (Minecraft.getInstance().getConnection() == null) {
                return -1;
            }
            Registry registry = Minecraft.getInstance().getConnection().registryAccess().registryOrThrow(ModRegistries.CELL_TYPE);
            CellType cellType = (CellType)registry.get(cellId);
            if (cellType == null) {
                return -1;
            }
            int color = cellType.color();
            return (color & 0xFF000000) == 0 ? color | 0xFF000000 : color;
        }, new ItemLike[]{(ItemLike)ModItems.CELL_CULTURE.get()});
        event.register((stack, tintIndex) -> {
            ResourceLocation traitId = (ResourceLocation)stack.getComponents().get(ModDataComponents.BIOTRAIT.get());
            if (traitId == null) {
                return -1;
            }
            if (Minecraft.getInstance().getConnection() == null) {
                return -1;
            }
            Registry registry = Minecraft.getInstance().getConnection().registryAccess().registryOrThrow(ModRegistries.BIOTRAIT);
            Biotrait biotrait = (Biotrait)registry.get(traitId);
            if (biotrait == null) {
                return -1;
            }
            int color = SymbiontClient.brightenColor(biotrait.type().getColor(), 1.5f);
            return (color & 0xFF000000) == 0 ? color | 0xFF000000 : color;
        }, new ItemLike[]{(ItemLike)ModItems.BIOTRAIT_EXTRACT.get()});
        fluidTypeExtensions.forEach((fluid, extension) -> event.register((stack, tintIndex) -> tintIndex == 1 ? extension.getTintColor() : -1, new ItemLike[]{((FlowingFluid)fluid.get()).getBucket()}));
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        for (Map.Entry entry : FileToIdConverter.json((String)"models/cell_type").listMatchingResources(Minecraft.getInstance().getResourceManager()).entrySet()) {
            ResourceLocation cellType = ResourceLocation.parse((String)((ResourceLocation)entry.getKey()).toString().replace("models/cell_type", "cell_type").replace(".json", ""));
            event.register(ModelResourceLocation.standalone((ResourceLocation)cellType));
        }
    }

    @SubscribeEvent
    public static void modifyBakingResults(ModelEvent.ModifyBakingResult event) {
        event.getModels().computeIfPresent(ModelResourceLocation.inventory((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"symbiont", (String)"cell_culture")), (location, model) -> new CellCultureModelWrapper((BakedModel)model));
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        fluidTypeExtensions.forEach((fluid, extension) -> event.registerFluidType(extension, new FluidType[]{((FlowingFluid)fluid.get()).getFluidType()}));
    }

    private static IClientFluidTypeExtensions createFluidType(final ResourceLocation stillTexture, final ResourceLocation flowingTexture, final int color) {
        return new IClientFluidTypeExtensions(){

            public int getTintColor() {
                return color;
            }

            @NotNull
            public ResourceLocation getStillTexture() {
                return stillTexture;
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return flowingTexture;
            }
        };
    }

    private static int brightenColor(int color, float factor) {
        int a = color >>> 24 & 0xFF;
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.min(255, (int)((float)r * factor));
        g = Math.min(255, (int)((float)g * factor));
        b = Math.min(255, (int)((float)b * factor));
        if (a == 0) {
            a = 255;
        }
        return a << 24 | r << 16 | g << 8 | b;
    }
}

