/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.client.compat;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.client.compat.ModJeiRecipeTypes;
import piotro15.symbiont.common.recipe.BioformerRecipe;
import piotro15.symbiont.common.registry.ModItems;

public class BioformerRecipeCategory
extends AbstractRecipeCategory<BioformerRecipe> {
    private final IDrawableAnimated arrow;
    private final IDrawableStatic background;
    private final IDrawableStatic tankOverlay;

    public BioformerRecipeCategory(IGuiHelper helper) {
        super(ModJeiRecipeTypes.BIOFORMER, (Component)Component.translatable((String)"container.bioformer"), helper.createDrawableItemLike((ItemLike)ModItems.BIOFORMER.get()), 126, 54);
        this.arrow = helper.createAnimatedRecipeArrow(120);
        this.background = helper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"symbiont", (String)"textures/gui/bioformer.png"), 34, 16, 126, 54);
        this.tankOverlay = helper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"symbiont", (String)"textures/gui/fluid_tank_overlay.png"), 0, 0, 16, 52).setTextureSize(16, 52).build();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BioformerRecipe recipe, @NotNull IFocusGroup focuses) {
        IRecipeSlotBuilder fluidInputSlot = builder.addInputSlot(1, 1).setFluidRenderer(1L, false, 16, 52).setOverlay((IDrawable)this.tankOverlay, 0, 0);
        for (FluidStack fluid : recipe.fluidInput().getFluids()) {
            fluidInputSlot.addFluidStack(fluid.getFluid(), (long)fluid.getAmount());
        }
        IRecipeSlotBuilder itemInput = builder.addInputSlot(28, 10);
        itemInput.addIngredients(recipe.itemInput());
        IRecipeSlotBuilder catalyst = builder.addInputSlot(28, 28);
        catalyst.addIngredients(recipe.catalyst());
        for (int i = 0; i < 4; ++i) {
            int y;
            ItemStack stack = recipe.output() != null && recipe.output().size() > i ? (ItemStack)recipe.output().get(i) : null;
            int x = i % 2 == 0 ? 91 : 109;
            int n = y = i < 2 ? 10 : 28;
            if (stack != null) {
                builder.addOutputSlot(x, y).addItemStack(stack);
                continue;
            }
            builder.addOutputSlot(x, y);
        }
    }

    public void draw(@NotNull BioformerRecipe recipe, @NotNull IRecipeSlotsView slots, @NotNull GuiGraphics gfx, double mouseX, double mouseY) {
        this.background.draw(gfx);
        this.arrow.draw(gfx, 56, 19);
    }
}

