/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.client.compat;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import piotro15.symbiont.client.compat.BioformerRecipeCategory;
import piotro15.symbiont.client.compat.BioreactorRecipeCategory;
import piotro15.symbiont.client.compat.MetabolizerRecipeCategory;
import piotro15.symbiont.client.compat.ModJeiRecipeTypes;
import piotro15.symbiont.common.registry.ModDataComponents;
import piotro15.symbiont.common.registry.ModItems;
import piotro15.symbiont.common.registry.ModRecipeTypes;

@JeiPlugin
public class SymbiontJeiPlugin
implements IModPlugin {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"symbiont", (String)"jei_plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.CELL_CULTURE.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @Nullable
            public Object getSubtypeData(@NotNull ItemStack ingredient, @NotNull UidContext context) {
                return ingredient.get(ModDataComponents.CELL_TYPE.get());
            }

            @NotNull
            public String getLegacyStringSubtypeInfo(@NotNull ItemStack ingredient, @NotNull UidContext context) {
                ResourceLocation blendId = (ResourceLocation)ingredient.get(ModDataComponents.CELL_TYPE.get());
                if (blendId != null) {
                    return blendId.toString();
                }
                return "";
            }
        });
        registration.registerSubtypeInterpreter((Item)ModItems.BIOTRAIT_EXTRACT.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @Nullable
            public Object getSubtypeData(@NotNull ItemStack ingredient, @NotNull UidContext context) {
                return ingredient.get(ModDataComponents.BIOTRAIT.get());
            }

            @NotNull
            public String getLegacyStringSubtypeInfo(@NotNull ItemStack ingredient, @NotNull UidContext context) {
                ResourceLocation blendId = (ResourceLocation)ingredient.get(ModDataComponents.BIOTRAIT.get());
                if (blendId != null) {
                    return blendId.toString();
                }
                return "";
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers helpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = helpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new BioreactorRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MetabolizerRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BioformerRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(ModJeiRecipeTypes.BIOREACTOR, Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(ModRecipeTypes.BIOREACTOR.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(ModJeiRecipeTypes.METABOLIZER, Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(ModRecipeTypes.METABOLIZER.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(ModJeiRecipeTypes.BIOFORMER, Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(ModRecipeTypes.BIOFORMER.get()).stream().map(RecipeHolder::value).toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)ModItems.METABOLIZER.get(), new RecipeType[]{ModJeiRecipeTypes.METABOLIZER});
        registration.addRecipeCatalyst((ItemLike)ModItems.BIOREACTOR.get(), new RecipeType[]{ModJeiRecipeTypes.BIOREACTOR});
        registration.addRecipeCatalyst((ItemLike)ModItems.BIOFORMER.get(), new RecipeType[]{ModJeiRecipeTypes.BIOFORMER});
    }
}

