/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.common.menu.BasicMachineMenu;
import piotro15.symbiont.util.BarRenderer;

public abstract class BasicMachineScreen<M extends BasicMachineMenu>
extends AbstractContainerScreen<M> {
    private static final ResourceLocation ARROW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"symbiont", (String)"textures/gui/arrow_progress.png");
    protected final List<BarRenderer> bars = new ArrayList<BarRenderer>();

    public BasicMachineScreen(M menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void renderBg(GuiGraphics gfx, float v, int i, int i1) {
        gfx.blit(this.getTexture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.bars.forEach(bar -> bar.render(gfx, this.leftPos, this.topPos));
    }

    public void render(@NotNull GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        super.render(gfx, mouseX, mouseY, partialTick);
        this.renderTooltip(gfx, mouseX, mouseY);
        this.bars.forEach(bar -> bar.renderOverlay(gfx, this.leftPos, this.topPos));
        this.bars.forEach(bar -> bar.renderTooltip(gfx, this.leftPos, this.topPos, mouseX, mouseY));
    }

    public abstract ResourceLocation getTexture();

    protected void renderProgressArrow(GuiGraphics gfx, int x, int y) {
        if (((BasicMachineMenu)this.menu).isCrafting()) {
            gfx.blit(ARROW_TEXTURE, x, y, 0.0f, 0.0f, ((BasicMachineMenu)this.menu).getScaledArrowProgress(), 16, 24, 16);
        }
    }
}

