/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import piotro15.symbiont.client.screen.BasicMachineScreen;
import piotro15.symbiont.common.menu.MetabolizerMenu;
import piotro15.symbiont.util.EnergyBarRenderer;
import piotro15.symbiont.util.FluidTankRenderer;

@OnlyIn(value=Dist.CLIENT)
public class MetabolizerScreen
extends BasicMachineScreen<MetabolizerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"symbiont", (String)"textures/gui/metabolizer.png");

    public MetabolizerScreen(MetabolizerMenu menu, Inventory playerInv, Component title) {
        super(menu, playerInv, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.inventoryLabelY = this.imageHeight - 94;
        this.bars.add(new FluidTankRenderer(menu.getInputFluidTank(), 35, 17, 16, 52));
        this.bars.add(new FluidTankRenderer(menu.getOutputFluidTank(), 152, 17, 16, 52));
        this.bars.add(new EnergyBarRenderer(() -> menu.getContainerData(2), () -> menu.getContainerData(3), 8, 17, 16, 52));
    }

    @Override
    protected void renderBg(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(gfx, partialTicks, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderProgressArrow(gfx, 86 + x, 48 + y);
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }
}

