/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.client.screen.BasicMachineScreen;
import piotro15.symbiont.common.Symbiont;
import piotro15.symbiont.common.item.CellCultureItem;
import piotro15.symbiont.common.menu.RecombinatorMenu;

@OnlyIn(value=Dist.CLIENT)
public class RecombinatorScreen
extends BasicMachineScreen<RecombinatorMenu> {
    private static final ResourceLocation TEXTURE = Symbiont.id("textures/gui/recombinator.png");

    public RecombinatorScreen(RecombinatorMenu menu, Inventory playerInv, Component title) {
        super(menu, playerInv, title);
        this.imageWidth = 176;
        this.imageHeight = 199;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    @Override
    protected void renderBg(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        gfx.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void render(@NotNull GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        super.render(gfx, mouseX, mouseY, partialTick);
        if (((RecombinatorMenu)this.menu).hasCell()) {
            gfx.blit(Symbiont.id("textures/gui/recombinator_cell.png"), this.leftPos + 61, this.topPos + 20, 0.0f, 0.0f, 54, 54, 54, 54);
        }
        if (mouseX >= this.leftPos + 58 && mouseX < this.leftPos + 117 && mouseY >= this.topPos + 17 && mouseY < this.topPos + 76) {
            List<CellCultureItem.AppliedBiotrait> result = ((RecombinatorMenu)this.menu).getResultingBiocode();
            if (result.isEmpty()) {
                return;
            }
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(Component.translatable((String)"item.symbiont.cell_culture.prediction"));
            tooltip.addAll(CellCultureItem.createTooltip(result, RecombinatorScreen.hasControlDown()));
            gfx.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }
}

