/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.slf4j.Logger;
import piotro15.symbiont.common.block.entity.BasicMachineBlockEntity;
import piotro15.symbiont.common.block.entity.MachineWorkerBlockEntity;
import piotro15.symbiont.common.config.Config;
import piotro15.symbiont.common.genetics.TraitModifierRegistry;
import piotro15.symbiont.common.registry.ModBlockEntities;
import piotro15.symbiont.common.registry.ModBlocks;
import piotro15.symbiont.common.registry.ModCreativeModeTabs;
import piotro15.symbiont.common.registry.ModDataComponents;
import piotro15.symbiont.common.registry.ModFluidTypes;
import piotro15.symbiont.common.registry.ModFluids;
import piotro15.symbiont.common.registry.ModItems;
import piotro15.symbiont.common.registry.ModMenuTypes;
import piotro15.symbiont.common.registry.ModRecipeSerializers;
import piotro15.symbiont.common.registry.ModRecipeTypes;
import piotro15.symbiont.common.registry.ModRegistries;

@Mod(value="symbiont")
public class Symbiont {
    public static final String MOD_ID = "symbiont";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Symbiont(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(ModRegistries::registerDataRegistry);
        ModDataComponents.REGISTRAR.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModFluidTypes.FLUID_TYPES.register(modEventBus);
        ModFluids.FLUIDS.register(modEventBus);
        ModMenuTypes.MENU_TYPES.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITY_TYPE.register(modEventBus);
        ModRecipeTypes.RECIPE_TYPES.register(modEventBus);
        ModRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        modEventBus.addListener(this::registerCapabilities);
        TraitModifierRegistry.registerConditions();
        ModCreativeModeTabs.CREATIVE_TABS.register(modEventBus);
        modEventBus.addListener(ModItems::buildContents);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.MACHINE_WORKER.get(), MachineWorkerBlockEntity::getItemHandlerForSide);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntities.MACHINE_WORKER.get(), MachineWorkerBlockEntity::getFluidHandlerForSide);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntities.MACHINE_WORKER.get(), MachineWorkerBlockEntity::getEnergyStorageForSide);
        List<BlockEntityType> registeredBlockEntities = List.of((BlockEntityType)ModBlockEntities.BIOREACTOR.get(), (BlockEntityType)ModBlockEntities.METABOLIZER.get(), (BlockEntityType)ModBlockEntities.BIOFORMER.get(), (BlockEntityType)ModBlockEntities.CENTRIFUGE.get());
        for (BlockEntityType type : registeredBlockEntities) {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, type, (be, direction) -> ((BasicMachineBlockEntity)((Object)be)).getItemHandlerForSide((Direction)direction));
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, type, (be, direction) -> ((BasicMachineBlockEntity)((Object)be)).getFluidHandlerForSide((Direction)direction));
            event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, type, (be, direction) -> ((BasicMachineBlockEntity)((Object)be)).getEnergyStorageForSide((Direction)direction));
        }
    }
}

