/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import piotro15.symbiont.common.block.entity.RecombinatorBlockEntity;

public class RecombinatorBlock
extends BaseEntityBlock {
    public static final MapCodec<RecombinatorBlock> CODEC = RecombinatorBlock.simpleCodec(RecombinatorBlock::new);
    public static final DirectionProperty FACING;
    public static final BooleanProperty TRIGGERED;
    private static final VoxelShape SHAPE_NS;
    private static final VoxelShape SHAPE_EW;

    public RecombinatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)blockEntity;
            player.openMenu(menuProvider, pos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean flag = level.hasNeighborSignal(pos);
        boolean flag1 = (Boolean)state.getValue((Property)TRIGGERED);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (flag && !flag1) {
            level.scheduleTick(pos, (Block)this, 4);
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 2);
            if (blockEntity instanceof RecombinatorBlockEntity) {
                RecombinatorBlockEntity recombinatorBlockEntity = (RecombinatorBlockEntity)blockEntity;
                recombinatorBlockEntity.setTriggered();
            }
        } else if (flag1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new RecombinatorBlockEntity(blockPos, blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TRIGGERED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return state.getValue((Property)FACING) == Direction.NORTH || state.getValue((Property)FACING) == Direction.SOUTH ? SHAPE_NS : SHAPE_EW;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    static {
        SHAPE_NS = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)5.0, (double)1.0, (double)16.0, (double)11.0), Block.box((double)15.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0)});
        SHAPE_EW = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)1.0), Block.box((double)5.0, (double)0.0, (double)15.0, (double)11.0, (double)16.0, (double)16.0)});
        FACING = BlockStateProperties.HORIZONTAL_FACING;
        TRIGGERED = BlockStateProperties.TRIGGERED;
    }
}

