/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.block.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import piotro15.symbiont.common.block.entity.BasicMachineBlockEntity;
import piotro15.symbiont.common.genetics.Biocode;
import piotro15.symbiont.common.item.CellCultureItem;
import piotro15.symbiont.common.menu.BioformerMenu;
import piotro15.symbiont.common.recipe.BioformerRecipe;
import piotro15.symbiont.common.recipe.BioformerRecipeInput;
import piotro15.symbiont.common.registry.ModBlockEntities;
import piotro15.symbiont.common.registry.ModDataComponents;
import piotro15.symbiont.common.registry.ModItems;
import piotro15.symbiont.common.registry.ModRecipeTypes;
import piotro15.symbiont.util.DynamicFluidTank;
import piotro15.symbiont.util.DynamicItemStackHandler;
import piotro15.symbiont.util.ItemUtils;

public class BioformerBlockEntity
extends BasicMachineBlockEntity
implements MenuProvider {
    private final DynamicFluidTank inputTank = new DynamicFluidTank(4000, this);
    private final EnergyStorage energyStorage = new EnergyStorage(10000, 100);
    protected ItemStackHandler inventory = new DynamicItemStackHandler(6, this);
    private int progress;
    private static final int MAX_PROGRESS = 200;

    public BioformerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BIOFORMER.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> BioformerBlockEntity.this.progress;
                    case 1 -> BioformerBlockEntity.this.getMaxProgress();
                    case 2 -> BioformerBlockEntity.this.energyStorage.getEnergyStored();
                    case 3 -> BioformerBlockEntity.this.energyStorage.getMaxEnergyStored();
                    default -> 0;
                };
            }

            public void set(int i, int value) {
            }

            public int getCount() {
                return 4;
            }
        };
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        Tag energy;
        super.loadAdditional(tag, lookup);
        this.inventory.deserializeNBT(lookup, tag.getCompound("Inventory"));
        this.progress = tag.getInt("Progress");
        if (tag.contains("Energy") && (energy = tag.get("Energy")) != null) {
            this.energyStorage.deserializeNBT(lookup, energy);
        }
        this.inputTank.readFromNBT(lookup, tag.getCompound("InputTank"));
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(lookup));
        tag.putInt("Progress", this.progress);
        tag.put("Energy", this.energyStorage.serializeNBT(lookup));
        CompoundTag inputTag = new CompoundTag();
        this.inputTank.writeToNBT(lookup, inputTag);
        tag.put("InputTank", (Tag)inputTag);
    }

    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInv, @NotNull Player player) {
        return new BioformerMenu(id, playerInv, this, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.bioformer");
    }

    private void craftRecipe(BioformerRecipe recipe) {
        int countChange;
        double productionMultiplier;
        if (this.level == null) {
            return;
        }
        double consumptionMultiplier = 1.0;
        ItemStack inputItem = this.inventory.getStackInSlot(0);
        if (inputItem.is(ModItems.CELL_CULTURE)) {
            productionMultiplier = CellCultureItem.getProduction(inputItem);
            consumptionMultiplier = CellCultureItem.getConsumption(inputItem);
            countChange = CellCultureItem.getCountChange(inputItem, this.level.random);
            if (countChange < 0) {
                this.inventory.extractItem(0, 1, false);
            }
        } else {
            productionMultiplier = 1.0;
            countChange = 0;
            if (!recipe.itemInput().isEmpty()) {
                this.inventory.extractItem(0, 1, false);
            }
        }
        this.inputTank.drain(ItemUtils.randomCount(recipe.fluidInput().amount(), consumptionMultiplier, this.level.random), IFluidHandler.FluidAction.EXECUTE);
        recipe.output().forEach(stack -> {
            ItemStack adjustedResultItem = ItemStack.EMPTY;
            if (stack.is(ModItems.CELL_CULTURE) && inputItem.is(ModItems.CELL_CULTURE)) {
                if (countChange > 0) {
                    Biocode biocode = (Biocode)inputItem.get(ModDataComponents.BIOCODE);
                    adjustedResultItem = stack.copyWithCount(countChange);
                    if (biocode != null) {
                        adjustedResultItem.set(ModDataComponents.BIOCODE, (Object)biocode);
                    }
                }
            } else {
                int randomCount = ItemUtils.randomCount(stack.getCount(), productionMultiplier, this.level.random);
                if (randomCount <= 0) {
                    return;
                }
                adjustedResultItem = stack.copyWithCount(randomCount);
            }
            ItemUtils.insertIntoInventory(this.inventory, adjustedResultItem, 2, 6);
        });
    }

    private boolean canAcceptOutput(BioformerRecipe recipe) {
        if (this.level == null) {
            return false;
        }
        NonNullList<ItemStack> result = recipe.output();
        double productionMultiplier = 1.0;
        double stability = 1.0;
        ItemStack inputItem = this.inventory.getStackInSlot(0);
        if (inputItem.is(ModItems.CELL_CULTURE)) {
            productionMultiplier = CellCultureItem.getProduction(inputItem);
            stability = CellCultureItem.getStability(inputItem);
        }
        NonNullList adjustedResult = NonNullList.create();
        for (ItemStack stack : result) {
            if (stack.is(ModItems.CELL_CULTURE) && inputItem.is(ModItems.CELL_CULTURE)) {
                if (!(stability > 1.0)) continue;
                Biocode biocode = (Biocode)inputItem.get(ModDataComponents.BIOCODE);
                ItemStack adjustedResultItem = stack.copyWithCount((int)Math.ceil(stability - 1.0));
                if (biocode == null) continue;
                adjustedResultItem.set(ModDataComponents.BIOCODE, (Object)biocode);
                continue;
            }
            int maxCount = (int)Math.ceil((double)stack.getCount() * productionMultiplier);
            adjustedResult.add((Object)stack.copyWithCount(maxCount));
        }
        return ItemUtils.canFitOutputs(this.inventory, (List<ItemStack>)adjustedResult, 2, 6);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public int getMaxProgress() {
        if (this.inventory.getStackInSlot(0).is(ModItems.CELL_CULTURE)) {
            double progressMultiplier = CellCultureItem.getGrowth(this.inventory.getStackInSlot(0));
            return (int)(200.0 / progressMultiplier);
        }
        return 200;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, BasicMachineBlockEntity blockEntity) {
        if (this.energyStorage.getEnergyStored() < 20) {
            this.progress = 0;
            return;
        }
        BioformerRecipeInput input = new BioformerRecipeInput(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1), this.inputTank.getFluid());
        if (level == null) {
            return;
        }
        Optional recipeMatch = level.getRecipeManager().getRecipeFor(ModRecipeTypes.BIOFORMER.get(), (RecipeInput)input, level);
        if (recipeMatch.isEmpty()) {
            this.progress = 0;
            return;
        }
        BioformerRecipe match = (BioformerRecipe)((RecipeHolder)recipeMatch.get()).value();
        if (this.canAcceptOutput(match)) {
            this.energyStorage.extractEnergy(20, false);
            ++this.progress;
            if (this.progress >= this.getMaxProgress()) {
                this.craftRecipe(match);
                this.progress = 0;
            }
        }
    }

    @Override
    @Nullable
    public IItemHandler getItemHandlerForSide(@Nullable Direction side) {
        return this.inventory;
    }

    @Override
    @Nullable
    public IFluidHandler getFluidHandlerForSide(@Nullable Direction side) {
        return this.inputTank;
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyStorageForSide(@Nullable Direction side) {
        return this.energyStorage;
    }
}

