/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import piotro15.symbiont.common.block.entity.BasicMachineBlockEntity;
import piotro15.symbiont.common.genetics.Biocode;
import piotro15.symbiont.common.item.CellCultureItem;
import piotro15.symbiont.common.menu.BioreactorMenu;
import piotro15.symbiont.common.recipe.BioreactorRecipe;
import piotro15.symbiont.common.recipe.BioreactorRecipeInput;
import piotro15.symbiont.common.registry.ModBlockEntities;
import piotro15.symbiont.common.registry.ModDataComponents;
import piotro15.symbiont.common.registry.ModItems;
import piotro15.symbiont.common.registry.ModRecipeTypes;
import piotro15.symbiont.util.DynamicFluidTank;
import piotro15.symbiont.util.DynamicItemStackHandler;
import piotro15.symbiont.util.FluidUtils;
import piotro15.symbiont.util.ItemUtils;

public class BioreactorBlockEntity
extends BasicMachineBlockEntity
implements MenuProvider {
    private final DynamicFluidTank inputTank = new DynamicFluidTank(4000, this);
    private final DynamicFluidTank outputTank = new DynamicFluidTank(4000, this);
    private final EnergyStorage energyStorage = new EnergyStorage(10000, 100);
    protected ItemStackHandler inventory = new DynamicItemStackHandler(2, this);
    private int progress;
    private static final int MAX_PROGRESS = 200;

    public BioreactorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BIOREACTOR.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> BioreactorBlockEntity.this.progress;
                    case 1 -> BioreactorBlockEntity.this.getMaxProgress();
                    case 2 -> BioreactorBlockEntity.this.energyStorage.getEnergyStored();
                    case 3 -> BioreactorBlockEntity.this.energyStorage.getMaxEnergyStored();
                    default -> 0;
                };
            }

            public void set(int i, int value) {
            }

            public int getCount() {
                return 4;
            }
        };
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        Tag energy;
        super.loadAdditional(tag, lookup);
        this.inventory.deserializeNBT(lookup, tag.getCompound("Inventory"));
        this.progress = tag.getInt("Progress");
        if (tag.contains("Energy") && (energy = tag.get("Energy")) != null) {
            this.energyStorage.deserializeNBT(lookup, energy);
        }
        this.inputTank.readFromNBT(lookup, tag.getCompound("InputTank"));
        this.outputTank.readFromNBT(lookup, tag.getCompound("OutputTank"));
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(lookup));
        tag.putInt("Progress", this.progress);
        tag.put("Energy", this.energyStorage.serializeNBT(lookup));
        CompoundTag inputTag = new CompoundTag();
        this.inputTank.writeToNBT(lookup, inputTag);
        tag.put("InputTank", (Tag)inputTag);
        CompoundTag outputTag = new CompoundTag();
        this.outputTank.writeToNBT(lookup, outputTag);
        tag.put("OutputTank", (Tag)outputTag);
    }

    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInv, @NotNull Player player) {
        return new BioreactorMenu(id, playerInv, this, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.bioreactor");
    }

    private void craftRecipe(BioreactorRecipe recipe) {
        if (this.level == null) {
            return;
        }
        ItemStack inputItem = this.inventory.getStackInSlot(0);
        ItemStack resultItem = recipe.output();
        if (inputItem.is(ModItems.CELL_CULTURE) && resultItem.is(ModItems.CELL_CULTURE)) {
            double productionMultiplier = CellCultureItem.getProduction(inputItem);
            double consumptionMultiplier = CellCultureItem.getConsumption(inputItem);
            int countChange = CellCultureItem.getCountChange(inputItem, this.level.random);
            if (countChange < 0) {
                this.inventory.extractItem(0, 1, false);
            }
            this.inputTank.drain(ItemUtils.randomCount(recipe.fluidInput().amount(), consumptionMultiplier, this.level.random), IFluidHandler.FluidAction.EXECUTE);
            if (countChange > 0) {
                Biocode biocode = (Biocode)inputItem.get(ModDataComponents.BIOCODE);
                resultItem = resultItem.copyWithCount(countChange);
                if (biocode != null) {
                    resultItem.set(ModDataComponents.BIOCODE, (Object)biocode);
                }
                this.inventory.insertItem(1, resultItem, false);
            }
            this.outputTank.fill(recipe.fluidOutput().copyWithAmount(ItemUtils.randomCount(recipe.fluidOutput().getAmount(), productionMultiplier, this.level.random)), IFluidHandler.FluidAction.EXECUTE);
        } else {
            this.inventory.extractItem(0, 1, false);
            this.inputTank.drain(recipe.fluidInput().amount(), IFluidHandler.FluidAction.EXECUTE);
            this.inventory.insertItem(1, recipe.output(), false);
            this.outputTank.fill(recipe.fluidOutput(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private boolean canAcceptOutput(BioreactorRecipe recipe) {
        FluidStack fluidResult;
        if (this.level == null) {
            return false;
        }
        ItemStack inputItem = this.inventory.getStackInSlot(0);
        ItemStack resultItem = recipe.output();
        ItemStack result = ItemStack.EMPTY;
        if (inputItem.is(ModItems.CELL_CULTURE) && resultItem.is(ModItems.CELL_CULTURE)) {
            double productionMultiplier = CellCultureItem.getProduction(inputItem);
            double stability = CellCultureItem.getStability(inputItem);
            if (stability > 1.0) {
                Biocode biocode = (Biocode)inputItem.get(ModDataComponents.BIOCODE);
                result = resultItem.copyWithCount((int)Math.ceil(stability - 1.0));
                if (biocode != null) {
                    result.set(ModDataComponents.BIOCODE, (Object)biocode);
                }
            }
            fluidResult = recipe.fluidOutput().copyWithAmount((int)Math.ceil((double)recipe.fluidOutput().getAmount() * productionMultiplier));
        } else {
            result = resultItem;
            fluidResult = recipe.fluidOutput();
        }
        boolean itemsFit = this.inventory.insertItem(1, result, true).isEmpty();
        boolean fluidsFit = this.outputTank.fill(fluidResult, IFluidHandler.FluidAction.SIMULATE) == fluidResult.getAmount();
        return itemsFit && fluidsFit;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public FluidTank getOutputTank() {
        return this.outputTank;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getMaxProgress() {
        if (this.inventory.getStackInSlot(0).is(ModItems.CELL_CULTURE)) {
            double progressMultiplier = CellCultureItem.getGrowth(this.inventory.getStackInSlot(0));
            return (int)(200.0 / progressMultiplier);
        }
        return 200;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, BasicMachineBlockEntity blockEntity) {
        if (this.energyStorage.getEnergyStored() < 20) {
            this.progress = 0;
            return;
        }
        BioreactorRecipeInput input = new BioreactorRecipeInput(this.inventory.getStackInSlot(0), this.inputTank.getFluid());
        if (level == null) {
            return;
        }
        Optional recipeMatch = level.getRecipeManager().getRecipeFor(ModRecipeTypes.BIOREACTOR.get(), (RecipeInput)input, level);
        if (recipeMatch.isEmpty()) {
            this.progress = 0;
            return;
        }
        BioreactorRecipe match = (BioreactorRecipe)((RecipeHolder)recipeMatch.get()).value();
        if (this.canAcceptOutput(match)) {
            this.energyStorage.extractEnergy(20, false);
            ++this.progress;
            if (this.progress >= this.getMaxProgress()) {
                this.craftRecipe(match);
                this.progress = 0;
            }
        }
    }

    @Override
    @Nullable
    public IItemHandler getItemHandlerForSide(@Nullable Direction side) {
        return this.inventory;
    }

    @Override
    @Nullable
    public IFluidHandler getFluidHandlerForSide(@Nullable Direction side) {
        return new FluidUtils.CombinedFluidHandler(this.inputTank, this.outputTank);
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyStorageForSide(@Nullable Direction side) {
        return this.energyStorage;
    }
}

