/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.block.entity;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import piotro15.symbiont.common.block.entity.BasicMachineBlockEntity;
import piotro15.symbiont.common.genetics.Biotrait;
import piotro15.symbiont.common.item.CellCultureItem;
import piotro15.symbiont.common.menu.CentrifugeMenu;
import piotro15.symbiont.common.registry.ModBlockEntities;
import piotro15.symbiont.common.registry.ModDataComponents;
import piotro15.symbiont.common.registry.ModFluids;
import piotro15.symbiont.common.registry.ModItems;
import piotro15.symbiont.common.registry.ModTags;
import piotro15.symbiont.util.DynamicFluidTank;
import piotro15.symbiont.util.DynamicItemStackHandler;
import piotro15.symbiont.util.FluidUtils;

public class CentrifugeBlockEntity
extends BasicMachineBlockEntity
implements MenuProvider {
    private final DynamicFluidTank inputTank = new DynamicFluidTank(4000, this);
    private final DynamicFluidTank outputTank = new DynamicFluidTank(4000, this);
    private final EnergyStorage energyStorage = new EnergyStorage(10000, 100);
    private final ItemStackHandler inventory = new DynamicItemStackHandler(3, this);
    private int progress;
    private static final int MAX_PROGRESS = 200;

    public CentrifugeBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CENTRIFUGE.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> CentrifugeBlockEntity.this.progress;
                    case 1 -> 200;
                    case 2 -> CentrifugeBlockEntity.this.energyStorage.getEnergyStored();
                    case 3 -> CentrifugeBlockEntity.this.energyStorage.getMaxEnergyStored();
                    default -> 0;
                };
            }

            public void set(int i, int value) {
            }

            public int getCount() {
                return 4;
            }
        };
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        Tag energy;
        super.loadAdditional(tag, lookup);
        this.inventory.deserializeNBT(lookup, tag.getCompound("Inventory"));
        this.progress = tag.getInt("Progress");
        if (tag.contains("Energy") && (energy = tag.get("Energy")) != null) {
            this.energyStorage.deserializeNBT(lookup, energy);
        }
        this.inputTank.readFromNBT(lookup, tag.getCompound("InputTank"));
        this.outputTank.readFromNBT(lookup, tag.getCompound("OutputTank"));
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(lookup));
        tag.putInt("Progress", this.progress);
        tag.put("Energy", this.energyStorage.serializeNBT(lookup));
        CompoundTag inputTag = new CompoundTag();
        this.inputTank.writeToNBT(lookup, inputTag);
        tag.put("InputTank", (Tag)inputTag);
        CompoundTag outputTag = new CompoundTag();
        this.outputTank.writeToNBT(lookup, outputTag);
        tag.put("OutputTank", (Tag)outputTag);
    }

    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInv, @NotNull Player player) {
        return new CentrifugeMenu(id, playerInv, this, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.centrifuge");
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public FluidTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, BasicMachineBlockEntity blockEntity) {
        if (this.energyStorage.getEnergyStored() < 20) {
            this.progress = 0;
            return;
        }
        if (!this.inputTank.getFluid().is(ModFluids.BIOPOLYMER_SOLUTION) || this.inputTank.getFluidAmount() < 1000) {
            this.progress = 0;
            return;
        }
        if (!this.inventory.getStackInSlot(0).is(ModItems.CELL_CULTURE)) {
            this.progress = 0;
            return;
        }
        ItemStack catalystStack = this.inventory.getStackInSlot(1);
        if (!catalystStack.is(ModTags.Items.CENTRIFUGE_CATALYSTS)) {
            this.progress = 0;
            return;
        }
        if (this.canAcceptOutput()) {
            this.energyStorage.extractEnergy(20, false);
            ++this.progress;
            if (this.progress >= 200) {
                this.craftRecipe();
                this.progress = 0;
            }
        }
    }

    private boolean canAcceptOutput() {
        Biotrait.BiotraitType biotraitType = this.inventory.getStackInSlot(1).is(ModTags.Items.STABILITY_CATALYSTS) ? Biotrait.BiotraitType.STABILITY : (this.inventory.getStackInSlot(1).is(ModTags.Items.METABOLISM_CATALYSTS) ? Biotrait.BiotraitType.METABOLISM : (this.inventory.getStackInSlot(1).is(ModTags.Items.REPLICATION_CATALYSTS) ? Biotrait.BiotraitType.REPLICATION : (this.inventory.getStackInSlot(1).is(ModTags.Items.ADAPTABILITY_CATALYSTS) ? Biotrait.BiotraitType.ADAPTABILITY : (this.inventory.getStackInSlot(1).is(ModTags.Items.SPECIAL_CATALYSTS) ? Biotrait.BiotraitType.SPECIAL : null))));
        ItemStack extract = new ItemStack((ItemLike)ModItems.BIOTRAIT_EXTRACT.get());
        AtomicBoolean emptyOutput = new AtomicBoolean(true);
        List<CellCultureItem.AppliedBiotrait> traits = CellCultureItem.getBiocode(this.inventory.getStackInSlot(0));
        if (traits != null) {
            traits.stream().filter(t -> t.type() == biotraitType).findFirst().ifPresent(t -> {
                extract.set(ModDataComponents.BIOTRAIT, (Object)t.traitId());
                emptyOutput.set(false);
            });
        }
        return emptyOutput.get() || this.inventory.insertItem(2, extract, true).isEmpty();
    }

    private void craftRecipe() {
        Biotrait.BiotraitType biotraitType = this.inventory.getStackInSlot(1).is(ModTags.Items.STABILITY_CATALYSTS) ? Biotrait.BiotraitType.STABILITY : (this.inventory.getStackInSlot(1).is(ModTags.Items.METABOLISM_CATALYSTS) ? Biotrait.BiotraitType.METABOLISM : (this.inventory.getStackInSlot(1).is(ModTags.Items.REPLICATION_CATALYSTS) ? Biotrait.BiotraitType.REPLICATION : (this.inventory.getStackInSlot(1).is(ModTags.Items.ADAPTABILITY_CATALYSTS) ? Biotrait.BiotraitType.ADAPTABILITY : (this.inventory.getStackInSlot(1).is(ModTags.Items.SPECIAL_CATALYSTS) ? Biotrait.BiotraitType.SPECIAL : null))));
        List<CellCultureItem.AppliedBiotrait> traits = CellCultureItem.getBiocode(this.inventory.getStackInSlot(0));
        if (traits != null) {
            traits.stream().filter(t -> t.type() == biotraitType).findFirst().ifPresent(t -> {
                ItemStack extract = new ItemStack((ItemLike)ModItems.BIOTRAIT_EXTRACT.get());
                extract.set(ModDataComponents.BIOTRAIT, (Object)t.traitId());
                this.inventory.insertItem(2, extract, false);
            });
        }
        this.inputTank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        this.inventory.extractItem(0, 1, false);
        this.inventory.extractItem(1, 1, false);
    }

    @Override
    @Nullable
    public IItemHandler getItemHandlerForSide(@Nullable Direction side) {
        return this.inventory;
    }

    @Override
    @Nullable
    public IFluidHandler getFluidHandlerForSide(@Nullable Direction side) {
        return new FluidUtils.CombinedFluidHandler(this.inputTank, this.outputTank);
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyStorageForSide(@Nullable Direction side) {
        return this.energyStorage;
    }
}

