/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.block.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.common.genetics.Biocode;
import piotro15.symbiont.common.genetics.Biotrait;
import piotro15.symbiont.common.item.BiotraitExtractItem;
import piotro15.symbiont.common.item.CellCultureItem;
import piotro15.symbiont.common.menu.RecombinatorMenu;
import piotro15.symbiont.common.registry.ModBlockEntities;
import piotro15.symbiont.common.registry.ModDataComponents;
import piotro15.symbiont.common.registry.ModItems;
import piotro15.symbiont.common.registry.ModRegistries;
import piotro15.symbiont.util.DynamicItemStackHandler;

public class RecombinatorBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler items = new DynamicItemStackHandler(this, 6, this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0 && stack.is(ModItems.CELL_CULTURE)) {
                return true;
            }
            if (slot > 0 && slot < 6 && stack.getItem() instanceof BiotraitExtractItem) {
                ResourceLocation traitId = (ResourceLocation)stack.get(ModDataComponents.BIOTRAIT);
                ClientPacketListener connection = Minecraft.getInstance().getConnection();
                if (connection == null) {
                    return false;
                }
                Registry registry = connection.registryAccess().registryOrThrow(ModRegistries.BIOTRAIT);
                Biotrait biotrait = (Biotrait)registry.get(traitId);
                if (biotrait == null) {
                    return false;
                }
                switch (slot) {
                    case 1: {
                        return biotrait.type() == Biotrait.BiotraitType.STABILITY;
                    }
                    case 2: {
                        return biotrait.type() == Biotrait.BiotraitType.METABOLISM;
                    }
                    case 3: {
                        return biotrait.type() == Biotrait.BiotraitType.REPLICATION;
                    }
                    case 4: {
                        return biotrait.type() == Biotrait.BiotraitType.ADAPTABILITY;
                    }
                    case 5: {
                        return biotrait.type() == Biotrait.BiotraitType.SPECIAL;
                    }
                }
                return false;
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? 1 : super.getSlotLimit(slot);
        }
    };

    public RecombinatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.RECOMBINATOR.get(), pos, state);
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.items.deserializeNBT(lookup, tag.getCompound("Inventory"));
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.put("Inventory", (Tag)this.items.serializeNBT(lookup));
    }

    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInv, @NotNull Player player) {
        return new RecombinatorMenu(id, playerInv, this.getBlockPos());
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.recombinator");
    }

    public ItemStackHandler getItems() {
        return this.items;
    }

    public List<CellCultureItem.AppliedBiotrait> getResultingBiocode() {
        ItemStack cellStack = this.items.getStackInSlot(0);
        if (cellStack.isEmpty() || !cellStack.is(ModItems.CELL_CULTURE)) {
            return List.of();
        }
        Biocode baseBiocode = (Biocode)cellStack.get(ModDataComponents.BIOCODE);
        HashMap<Object, Object> traits = baseBiocode == null ? new HashMap() : new HashMap<Biotrait.BiotraitType, ResourceLocation>(baseBiocode.traits());
        for (int slot = 1; slot <= 5; ++slot) {
            Registry registry;
            Biotrait biotrait;
            ItemStack vialStack = this.items.getStackInSlot(slot);
            if (vialStack.isEmpty() || !(vialStack.getItem() instanceof BiotraitExtractItem)) continue;
            ResourceLocation traitId = (ResourceLocation)vialStack.get(ModDataComponents.BIOTRAIT);
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            if (connection == null || (biotrait = (Biotrait)(registry = connection.registryAccess().registryOrThrow(ModRegistries.BIOTRAIT)).get(traitId)) == null) continue;
            traits.put((Object)biotrait.type(), traitId);
        }
        ArrayList<CellCultureItem.AppliedBiotrait> result = new ArrayList<CellCultureItem.AppliedBiotrait>();
        for (Map.Entry entry : traits.entrySet()) {
            Biotrait.BiotraitType type = (Biotrait.BiotraitType)((Object)entry.getKey());
            ResourceLocation id = (ResourceLocation)entry.getValue();
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            if (connection == null) {
                return List.of();
            }
            Registry registry = connection.registryAccess().registryOrThrow(ModRegistries.BIOTRAIT);
            Biotrait resolved = (Biotrait)registry.get(id);
            if (resolved == null) continue;
            result.add(new CellCultureItem.AppliedBiotrait(type, id, resolved));
        }
        return result;
    }

    public void setTriggered() {
        if (!this.items.getStackInSlot(0).is(ModItems.CELL_CULTURE)) {
            return;
        }
        ItemStack cellStack = this.items.getStackInSlot(0);
        Biocode biocodeComponent = (Biocode)cellStack.get(ModDataComponents.BIOCODE);
        HashMap<Object, Object> traits = biocodeComponent == null ? new HashMap() : new HashMap<Biotrait.BiotraitType, ResourceLocation>(biocodeComponent.traits());
        boolean changed = false;
        for (int i = 1; i <= 5; ++i) {
            Registry registry;
            Biotrait biotrait;
            ItemStack vialStack = this.items.getStackInSlot(i);
            if (vialStack.isEmpty() || !(vialStack.getItem() instanceof BiotraitExtractItem)) continue;
            ResourceLocation traitId = (ResourceLocation)vialStack.get(ModDataComponents.BIOTRAIT);
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            if (connection == null || (biotrait = (Biotrait)(registry = connection.registryAccess().registryOrThrow(ModRegistries.BIOTRAIT)).get(traitId)) == null) continue;
            traits.put((Object)biotrait.type(), traitId);
            this.items.extractItem(i, 1, false);
            changed = true;
        }
        if (changed) {
            cellStack.set(ModDataComponents.BIOCODE, (Object)new Biocode(traits));
        }
    }
}

