/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.genetics;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import piotro15.symbiont.common.genetics.Biotrait;
import piotro15.symbiont.common.registry.ModRegistries;

public record Biocode(Map<Biotrait.BiotraitType, ResourceLocation> traits) {
    public static final Codec<Biocode> CODEC = Codec.unboundedMap(Biotrait.BIOTRAIT_TYPE_CODEC, (Codec)ResourceLocation.CODEC).flatXmap(map -> DataResult.success((Object)new Biocode((Map<Biotrait.BiotraitType, ResourceLocation>)map)), biocode -> DataResult.success(biocode.traits()));
    public static final StreamCodec<ByteBuf, Biocode> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(Biocode::parse, Biocode::toString);

    public static Biocode parse(String s) {
        String[] entries;
        HashMap<Biotrait.BiotraitType, ResourceLocation> traits = new HashMap<Biotrait.BiotraitType, ResourceLocation>();
        s = s.replaceFirst("(Biocode\\[traits=\\{)", "");
        s = s.replaceFirst("}]$", "");
        for (String entry : entries = s.split(", ")) {
            String[] parts = entry.split("=");
            if (parts.length != 2) continue;
            try {
                Biotrait.BiotraitType type = Biotrait.BiotraitType.valueOf(parts[0]);
                ResourceLocation traitId = ResourceLocation.parse((String)parts[1]);
                traits.put(type, traitId);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid BiotraitType: " + parts[0]);
            }
        }
        return new Biocode(traits);
    }

    public String toString(Biocode biocode) {
        StringBuilder sb = new StringBuilder();
        biocode.traits().forEach((type, traitId) -> sb.append(type.toString()).append("=").append(traitId.toString()).append(";"));
        return sb.toString();
    }

    public static Map<Biotrait.BiotraitType, Biotrait> map(Map<Biotrait.BiotraitType, ResourceLocation> traitIds) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            return null;
        }
        return traitIds.entrySet().stream().map(entry -> {
            ResourceLocation traitId = (ResourceLocation)entry.getValue();
            Registry registry = connection.registryAccess().registryOrThrow(ModRegistries.BIOTRAIT);
            Biotrait trait = (Biotrait)registry.get(traitId);
            return trait == null ? null : Map.entry((Biotrait.BiotraitType)((Object)((Object)entry.getKey())), trait);
        }).filter(Objects::nonNull).collect(HashMap::new, (m, e) -> m.put((Biotrait.BiotraitType)((Object)((Object)e.getKey())), (Biotrait)e.getValue()), HashMap::putAll);
    }
}

