/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.genetics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import piotro15.symbiont.common.genetics.GenericTraitModifier;
import piotro15.symbiont.common.genetics.TraitModifierRegistry;

public record Biotrait(BiotraitType type, List<GenericTraitModifier> modifiers) {
    public static final Codec<Biotrait> CODEC;
    public static final StreamCodec<ByteBuf, Biotrait> STREAM_CODEC;
    public static final Codec<BiotraitType> BIOTRAIT_TYPE_CODEC;

    public Biotrait(BiotraitType type, GenericTraitModifier ... traitModifiers) {
        this(type, List.of(traitModifiers));
    }

    public static Biotrait parse(String s) {
        return new Biotrait(BiotraitType.valueOf(s), List.of());
    }

    static {
        BIOTRAIT_TYPE_CODEC = Codec.STRING.xmap(BiotraitType::valueOf, Enum::name);
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BIOTRAIT_TYPE_CODEC.fieldOf("trait_type").forGetter(Biotrait::type), (App)TraitModifierRegistry.CODEC.listOf().fieldOf("modifiers").forGetter(Biotrait::modifiers)).apply((Applicative)instance, Biotrait::new));
        STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(Biotrait::parse, Biotrait::toString);
    }

    public static enum BiotraitType {
        STABILITY(14427775, "symbiont.trait_type.stability"),
        METABOLISM(0xFFB000, "symbiont.trait_type.metabolism"),
        REPLICATION(7888624, "symbiont.trait_type.replication"),
        ADAPTABILITY(6590463, "symbiont.trait_type.adaptability"),
        SPECIAL(16670976, "symbiont.trait_type.special");

        private final int color;
        private final String translationKey;

        private BiotraitType(int color, String translationKey) {
            this.color = color;
            this.translationKey = translationKey;
        }

        public int getColor() {
            return this.color;
        }

        public Component getDisplayName() {
            return Component.translatable((String)this.translationKey).withColor(this.color);
        }
    }
}

