/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.genetics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import piotro15.symbiont.common.genetics.Biocode;
import piotro15.symbiont.common.genetics.Biotrait;

public record CellType(Biocode biocode, int color) {
    public static final Codec<CellType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Biocode.CODEC.fieldOf("biocode").forGetter(CellType::biocode), (App)Codec.INT.optionalFieldOf("color", (Object)0xFFFFFF).forGetter(CellType::color)).apply((Applicative)instance, CellType::new));

    public static class CellTypeBuilder {
        private Map<Biotrait.BiotraitType, ResourceLocation> traits = Map.of();
        private int color = 0xFFFFFF;

        public CellTypeBuilder setTraits(Map<Biotrait.BiotraitType, ResourceLocation> traits) {
            this.traits = traits;
            return this;
        }

        public CellTypeBuilder setColor(int color) {
            this.color = color;
            return this;
        }

        public CellType build() {
            return new CellType(new Biocode(this.traits), this.color);
        }
    }
}

