/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.genetics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import piotro15.symbiont.common.genetics.GenericTraitModifier;

public record IntegerTraitModifier(StatType statType, double value) implements GenericTraitModifier
{
    public static final ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"symbiont", (String)"integer_trait_modifier");
    public static final MapCodec<IntegerTraitModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("stat_type").flatXmap(type -> DataResult.success((Object)((Object)StatType.valueOf(type))), type -> DataResult.success((Object)type.toString())).forGetter(IntegerTraitModifier::statType), (App)Codec.DOUBLE.fieldOf("value").forGetter(IntegerTraitModifier::value)).apply((Applicative)instance, IntegerTraitModifier::new));

    @Override
    public ResourceLocation id() {
        return id;
    }

    @Override
    public Component getDisplayComponent() {
        String sign = this.value - 1.0 > 0.0 ? "+" : "";
        return this.statType.getDisplayName().withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)(sign + String.format("%.0f%%", (this.value - 1.0) * 100.0))).withStyle(this.statType.getColor()));
    }

    public static enum StatType {
        STABILITY(ChatFormatting.GREEN, "symbiont.stat.stability"),
        GROWTH(ChatFormatting.AQUA, "symbiont.stat.growth"),
        PRODUCTION(ChatFormatting.DARK_AQUA, "symbiont.stat.production"),
        CONSUMPTION(ChatFormatting.GOLD, "symbiont.stat.consumption");

        private final ChatFormatting color;
        private final String translationKey;

        private StatType(ChatFormatting color, String translationKey) {
            this.color = color;
            this.translationKey = translationKey;
        }

        public ChatFormatting getColor() {
            return this.color;
        }

        public MutableComponent getDisplayName() {
            return Component.translatable((String)this.translationKey);
        }
    }
}

