/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.common.genetics.Biotrait;
import piotro15.symbiont.common.registry.ModDataComponents;
import piotro15.symbiont.common.registry.ModRegistries;

public class BiotraitExtractItem
extends Item {
    public BiotraitExtractItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        ResourceLocation traitId = (ResourceLocation)stack.get(ModDataComponents.BIOTRAIT);
        if (traitId == null) {
            return;
        }
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            return;
        }
        Registry registry = connection.registryAccess().registryOrThrow(ModRegistries.BIOTRAIT);
        Biotrait biotrait = (Biotrait)registry.get(traitId);
        if (biotrait != null) {
            tooltipComponents.add((Component)Component.translatable((String)("biotrait." + traitId.getNamespace() + "." + traitId.getPath())).withColor(9463750));
            tooltipComponents.add((Component)Component.translatable((String)"symbiont.stat.type").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.GRAY)).append(biotrait.type().getDisplayName()));
            biotrait.modifiers().forEach(modifier -> tooltipComponents.add(modifier.getDisplayComponent()));
        }
    }
}

