/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.common.genetics.Biocode;
import piotro15.symbiont.common.genetics.Biotrait;
import piotro15.symbiont.common.genetics.CellType;
import piotro15.symbiont.common.genetics.IntegerTraitModifier;
import piotro15.symbiont.common.registry.ModDataComponents;
import piotro15.symbiont.common.registry.ModItems;
import piotro15.symbiont.common.registry.ModRegistries;

public class CellCultureItem
extends Item {
    public CellCultureItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Component getName(ItemStack stack) {
        ResourceLocation cellId = (ResourceLocation)stack.get(ModDataComponents.CELL_TYPE.get());
        if (cellId != null) {
            return Component.translatable((String)Util.makeDescriptionId((String)"cell_type", (ResourceLocation)cellId));
        }
        return super.getName(stack);
    }

    private static double getStat(ItemStack stack, IntegerTraitModifier.StatType statType) {
        AtomicReference<Double> stat = new AtomicReference<Double>(1.0);
        CellType cellType = CellCultureItem.getCellType(stack);
        if (cellType == null) {
            return stat.get();
        }
        List<AppliedBiotrait> traits = CellCultureItem.getBiocode(stack);
        if (traits == null) {
            return stat.get();
        }
        return CellCultureItem.getStat(traits, statType);
    }

    public static double getStat(List<AppliedBiotrait> traits, IntegerTraitModifier.StatType statType) {
        AtomicReference<Double> stat = new AtomicReference<Double>(1.0);
        traits.forEach(appliedBiotrait -> appliedBiotrait.trait().modifiers().forEach(modifier -> {
            block4: {
                if (modifier instanceof IntegerTraitModifier) {
                    double patt2$temp;
                    IntegerTraitModifier.StatType integerStatType;
                    IntegerTraitModifier $b$0 = (IntegerTraitModifier)modifier;
                    try {
                        IntegerTraitModifier.StatType patt1$temp;
                        integerStatType = patt1$temp = $b$0.statType();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    double value = patt2$temp = $b$0.value();
                    if (integerStatType != statType) break block4;
                    stat.updateAndGet(v -> v * value);
                }
            }
        }));
        return stat.get();
    }

    public static double getStability(ItemStack stack) {
        return CellCultureItem.getStat(stack, IntegerTraitModifier.StatType.STABILITY);
    }

    public static double getGrowth(ItemStack stack) {
        return CellCultureItem.getStat(stack, IntegerTraitModifier.StatType.GROWTH);
    }

    public static double getProduction(ItemStack stack) {
        return CellCultureItem.getStat(stack, IntegerTraitModifier.StatType.PRODUCTION);
    }

    public static double getConsumption(ItemStack stack) {
        return CellCultureItem.getStat(stack, IntegerTraitModifier.StatType.CONSUMPTION);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.addAll(CellCultureItem.getTooltipLines(stack, tooltipFlag));
    }

    public static List<Component> getTooltipLines(ItemStack stack, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltipComponents = new ArrayList<Component>();
        CellType cellType = CellCultureItem.getCellType(stack);
        if (cellType == null) {
            return tooltipComponents;
        }
        if (tooltipFlag.hasControlDown()) {
            List<AppliedBiotrait> traits = CellCultureItem.getBiocode(stack);
            if (traits == null || traits.isEmpty()) {
                return tooltipComponents;
            }
            tooltipComponents.add((Component)Component.translatable((String)"item.symbiont.cell_culture.traits").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.UNDERLINE}));
            traits.forEach(appliedBiotrait -> {
                tooltipComponents.add((Component)Component.literal((String)"\u2022 ").append(appliedBiotrait.type().getDisplayName()).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)("biotrait." + appliedBiotrait.traitId().getNamespace() + "." + appliedBiotrait.traitId().getPath())).withStyle(ChatFormatting.WHITE)));
                appliedBiotrait.trait().modifiers().forEach(mod -> tooltipComponents.add(mod.getDisplayComponent()));
            });
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.symbiont.cell_culture.stability").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(String.format("%.0f", CellCultureItem.getStability(stack) * 100.0) + "%")).withStyle(ChatFormatting.GREEN)));
            tooltipComponents.add((Component)Component.translatable((String)"item.symbiont.cell_culture.growth").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(String.format("%.0f", CellCultureItem.getGrowth(stack) * 100.0) + "%")).withStyle(ChatFormatting.AQUA)));
            tooltipComponents.add((Component)Component.translatable((String)"item.symbiont.cell_culture.production").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(String.format("%.0f", CellCultureItem.getProduction(stack) * 100.0) + "%")).withStyle(ChatFormatting.DARK_AQUA)));
            tooltipComponents.add((Component)Component.translatable((String)"item.symbiont.cell_culture.consumption").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(String.format("%.0f", CellCultureItem.getConsumption(stack) * 100.0) + "%")).withStyle(ChatFormatting.GOLD)));
        }
        return tooltipComponents;
    }

    public static List<Component> createTooltip(List<AppliedBiotrait> traits, boolean detailed) {
        ArrayList<Component> tooltipComponents = new ArrayList<Component>();
        if (detailed) {
            if (traits == null || traits.isEmpty()) {
                return tooltipComponents;
            }
            tooltipComponents.add((Component)Component.translatable((String)"item.symbiont.cell_culture.traits").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.UNDERLINE}));
            traits.forEach(appliedBiotrait -> {
                tooltipComponents.add((Component)Component.literal((String)"\u2022 ").append(appliedBiotrait.type().getDisplayName()).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)("biotrait." + appliedBiotrait.traitId().getNamespace() + "." + appliedBiotrait.traitId().getPath())).withStyle(ChatFormatting.WHITE)));
                appliedBiotrait.trait().modifiers().forEach(mod -> tooltipComponents.add(mod.getDisplayComponent()));
            });
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.symbiont.cell_culture.stability").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(String.format("%.0f", CellCultureItem.getStat(traits, IntegerTraitModifier.StatType.STABILITY) * 100.0) + "%")).withStyle(ChatFormatting.GREEN)));
            tooltipComponents.add((Component)Component.translatable((String)"item.symbiont.cell_culture.growth").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(String.format("%.0f", CellCultureItem.getStat(traits, IntegerTraitModifier.StatType.GROWTH) * 100.0) + "%")).withStyle(ChatFormatting.AQUA)));
            tooltipComponents.add((Component)Component.translatable((String)"item.symbiont.cell_culture.production").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(String.format("%.0f", CellCultureItem.getStat(traits, IntegerTraitModifier.StatType.PRODUCTION) * 100.0) + "%")).withStyle(ChatFormatting.DARK_AQUA)));
            tooltipComponents.add((Component)Component.translatable((String)"item.symbiont.cell_culture.consumption").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(String.format("%.0f", CellCultureItem.getStat(traits, IntegerTraitModifier.StatType.CONSUMPTION) * 100.0) + "%")).withStyle(ChatFormatting.GOLD)));
        }
        return tooltipComponents;
    }

    public static CellType getCellType(ItemStack stack) {
        ResourceLocation cellId = (ResourceLocation)stack.get(ModDataComponents.CELL_TYPE.get());
        if (cellId == null) {
            return null;
        }
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            return null;
        }
        Registry registry = connection.registryAccess().registryOrThrow(ModRegistries.CELL_TYPE);
        return (CellType)registry.get(cellId);
    }

    public static List<AppliedBiotrait> getBiocode(ItemStack stack) {
        CellType cellType = CellCultureItem.getCellType(stack);
        if (cellType == null) {
            return null;
        }
        Biocode biocodeComponent = (Biocode)stack.get(ModDataComponents.BIOCODE);
        HashMap<Biotrait.BiotraitType, ResourceLocation> traits = new HashMap<Biotrait.BiotraitType, ResourceLocation>(cellType.biocode().traits());
        if (biocodeComponent != null) {
            traits.putAll(biocodeComponent.traits());
        }
        ArrayList<AppliedBiotrait> result = new ArrayList<AppliedBiotrait>();
        for (Map.Entry entry : traits.entrySet()) {
            Biotrait.BiotraitType type = (Biotrait.BiotraitType)((Object)entry.getKey());
            ResourceLocation id = (ResourceLocation)entry.getValue();
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            if (connection == null) {
                return null;
            }
            Registry registry = connection.registryAccess().registryOrThrow(ModRegistries.BIOTRAIT);
            Biotrait resolved = (Biotrait)registry.get(id);
            if (resolved == null) continue;
            result.add(new AppliedBiotrait(type, id, resolved));
        }
        return result;
    }

    public static int getCountChange(ItemStack itemStack, RandomSource random) {
        int countChange = 0;
        if (!(itemStack.getItem() instanceof CellCultureItem)) {
            return countChange;
        }
        double stability = CellCultureItem.getStability(itemStack);
        if (stability < 1.0) {
            if (random.nextDouble() > stability) {
                countChange = -1;
            }
        } else if (stability > 1.0) {
            double extra = stability - 1.0;
            int guaranteedGrowth = (int)Math.floor(extra);
            double fractionalGrowthChance = extra - (double)guaranteedGrowth;
            countChange = guaranteedGrowth;
            if (random.nextDouble() < fractionalGrowthChance) {
                ++countChange;
            }
        }
        return countChange;
    }

    public static ItemStack withCellType(ResourceLocation cellTypeId) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.CELL_CULTURE.get());
        stack.set(ModDataComponents.CELL_TYPE.get(), (Object)cellTypeId);
        return stack;
    }

    public static Ingredient asIngredient(ResourceLocation cellTypeId) {
        return DataComponentIngredient.of((boolean)false, (DataComponentMap)DataComponentMap.builder().set(ModDataComponents.CELL_TYPE.get(), (Object)cellTypeId).build(), (ItemLike[])new ItemLike[]{(ItemLike)ModItems.CELL_CULTURE.get()});
    }

    public record AppliedBiotrait(Biotrait.BiotraitType type, ResourceLocation traitId, Biotrait trait) {
    }
}

