/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.menu;

import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.common.block.entity.BioformerBlockEntity;
import piotro15.symbiont.common.menu.BasicMachineMenu;
import piotro15.symbiont.common.registry.ModMenuTypes;
import piotro15.symbiont.util.OutputSlotItemHandler;

public class BioformerMenu
extends BasicMachineMenu {
    private final BioformerBlockEntity blockEntity;
    private final ContainerData data;

    public BioformerMenu(int id, Inventory playerInv, BioformerBlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.BIOFORMER.get(), id, 6, 2);
        this.blockEntity = blockEntity;
        this.data = data;
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.getInventory(), 0, 62, 26));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.getInventory(), 1, 62, 44));
        this.addSlot((Slot)new OutputSlotItemHandler((IItemHandler)blockEntity.getInventory(), 2, 125, 26));
        this.addSlot((Slot)new OutputSlotItemHandler((IItemHandler)blockEntity.getInventory(), 3, 143, 26));
        this.addSlot((Slot)new OutputSlotItemHandler((IItemHandler)blockEntity.getInventory(), 4, 125, 44));
        this.addSlot((Slot)new OutputSlotItemHandler((IItemHandler)blockEntity.getInventory(), 5, 143, 44));
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.addDataSlots(data);
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return this.blockEntity != null && this.blockEntity.getBlockPos().closerThan((Vec3i)player.blockPosition(), 8.0);
    }

    public FluidTank getInputFluidTank() {
        return this.blockEntity.getInputTank();
    }

    @Override
    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    @Override
    public int getScaledArrowProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.blockEntity.getMaxProgress();
        int arrowPixelSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * arrowPixelSize / maxProgress : 0;
    }

    public int getContainerData(int id) {
        return this.data.get(id);
    }
}

