/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.menu;

import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.common.block.entity.MetabolizerBlockEntity;
import piotro15.symbiont.common.menu.BasicMachineMenu;
import piotro15.symbiont.common.registry.ModMenuTypes;
import piotro15.symbiont.util.OutputSlotItemHandler;

public class MetabolizerMenu
extends BasicMachineMenu {
    private final MetabolizerBlockEntity blockEntity;
    private final ContainerData data;

    public MetabolizerMenu(int id, Inventory playerInv, MetabolizerBlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.METABOLIZER.get(), id, 6, 5);
        this.blockEntity = blockEntity;
        this.data = data;
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.getInventory(), 0, 63, 49));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.getInventory(), 1, 67, 17));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.getInventory(), 2, 85, 17));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.getInventory(), 3, 103, 17));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.getInventory(), 4, 121, 17));
        this.addSlot((Slot)new OutputSlotItemHandler((IItemHandler)blockEntity.getInventory(), 5, 121, 49));
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.addDataSlots(data);
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return this.blockEntity != null && this.blockEntity.getBlockPos().closerThan((Vec3i)player.blockPosition(), 8.0);
    }

    public FluidTank getInputFluidTank() {
        return this.blockEntity.getInputTank();
    }

    public FluidTank getOutputFluidTank() {
        return this.blockEntity.getOutputTank();
    }

    @Override
    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    @Override
    public int getScaledArrowProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int arrowPixelSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * arrowPixelSize / maxProgress : 0;
    }

    public int getContainerData(int id) {
        return this.data.get(id);
    }
}

