/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.common.item.CellCultureItem;
import piotro15.symbiont.common.recipe.BioformerRecipeInput;
import piotro15.symbiont.common.recipe.SymbiontRecipe;
import piotro15.symbiont.common.registry.ModRecipeSerializers;
import piotro15.symbiont.common.registry.ModRecipeTypes;

public record BioformerRecipe(Ingredient itemInput, Ingredient catalyst, SizedFluidIngredient fluidInput, NonNullList<ItemStack> output) implements SymbiontRecipe<BioformerRecipeInput>
{
    public boolean matches(BioformerRecipeInput input, @NotNull Level level) {
        double consumptionModifier = CellCultureItem.getConsumption(input.getItem(0));
        int amountNeeded = consumptionModifier != 1.0 ? (int)((double)this.fluidInput.amount() * consumptionModifier) : this.fluidInput.amount();
        if (!this.fluidInput.test(input.fluidInput()) || amountNeeded > input.fluidInput().getAmount()) {
            return false;
        }
        return this.itemInput.test(input.input()) && this.catalyst.test(input.catalyst());
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.BIOFORMER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return ModRecipeTypes.BIOFORMER.get();
    }

    public static class Serializer
    implements RecipeSerializer<BioformerRecipe> {
        public static final MapCodec<BioformerRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("item_input").forGetter(BioformerRecipe::itemInput), (App)Ingredient.CODEC.fieldOf("catalyst").forGetter(BioformerRecipe::catalyst), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid_input").forGetter(recipe -> recipe.fluidInput), (App)ItemStack.CODEC.listOf().fieldOf("output").flatXmap(outputs -> {
            Object[] testOutput = (ItemStack[])outputs.toArray(ItemStack[]::new);
            if (testOutput.length == 0) {
                return DataResult.error(() -> "Bioformer recipe has no outputs");
            }
            return DataResult.success((Object)NonNullList.of((Object)ItemStack.EMPTY, (Object[])testOutput));
        }, DataResult::success).forGetter(BioformerRecipe::output)).apply((Applicative)builder, BioformerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BioformerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<BioformerRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, BioformerRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static BioformerRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient itemInput = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient catalyst = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            SizedFluidIngredient fluidInput = (SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)buffer);
            int i = buffer.readVarInt();
            NonNullList outputs = NonNullList.withSize((int)i, (Object)ItemStack.EMPTY);
            outputs.replaceAll(ingredient -> (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
            return new BioformerRecipe(itemInput, catalyst, fluidInput, (NonNullList<ItemStack>)outputs);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, BioformerRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.itemInput);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.catalyst);
            SizedFluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluidInput);
            buffer.writeVarInt(recipe.output.size());
            for (ItemStack outputItem : recipe.output) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)outputItem);
            }
        }
    }
}

