/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.common.item.CellCultureItem;
import piotro15.symbiont.common.recipe.BioreactorRecipeInput;
import piotro15.symbiont.common.recipe.SymbiontRecipe;
import piotro15.symbiont.common.registry.ModRecipeSerializers;
import piotro15.symbiont.common.registry.ModRecipeTypes;

public record BioreactorRecipe(Ingredient itemInput, SizedFluidIngredient fluidInput, ItemStack output, FluidStack fluidOutput) implements SymbiontRecipe<BioreactorRecipeInput>
{
    public boolean matches(@NotNull BioreactorRecipeInput input, @NotNull Level level) {
        double consumptionModifier = CellCultureItem.getConsumption(input.getItem(0));
        int amountNeeded = consumptionModifier != 1.0 ? (int)((double)this.fluidInput.amount() * consumptionModifier) : this.fluidInput.amount();
        if (!this.fluidInput.test(input.fluidInput()) || amountNeeded > input.fluidInput().getAmount()) {
            return false;
        }
        return this.itemInput.test(input.stack());
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.BIOREACTOR.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return ModRecipeTypes.BIOREACTOR.get();
    }

    public static class Serializer
    implements RecipeSerializer<BioreactorRecipe> {
        public static final MapCodec<BioreactorRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("item_input").forGetter(recipe -> recipe.itemInput), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid_input").forGetter(recipe -> recipe.fluidInput), (App)ItemStack.CODEC.fieldOf("item_output").forGetter(recipe -> recipe.output), (App)FluidStack.CODEC.fieldOf("fluid_output").forGetter(recipe -> recipe.fluidOutput)).apply((Applicative)builder, BioreactorRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BioreactorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<BioreactorRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, BioreactorRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static BioreactorRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient itemInput = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            SizedFluidIngredient fluidInput = (SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)buffer);
            ItemStack itemOutput = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            FluidStack fluidOutput = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            return new BioreactorRecipe(itemInput, fluidInput, itemOutput, fluidOutput);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, BioreactorRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.itemInput);
            SizedFluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluidInput);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluidOutput);
        }
    }
}

