/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import piotro15.symbiont.common.item.CellCultureItem;
import piotro15.symbiont.common.recipe.MetabolizerRecipeInput;
import piotro15.symbiont.common.recipe.SymbiontRecipe;
import piotro15.symbiont.common.registry.ModRecipeSerializers;
import piotro15.symbiont.common.registry.ModRecipeTypes;

public record MetabolizerRecipe(NonNullList<Ingredient> ingredients, SizedFluidIngredient fluidInput, ItemStack output, FluidStack fluidOutput) implements SymbiontRecipe<MetabolizerRecipeInput>
{
    public boolean matches(MetabolizerRecipeInput input, @NotNull Level level) {
        double consumptionModifier = CellCultureItem.getConsumption(input.getItem(0));
        int amountNeeded = consumptionModifier != 1.0 ? (int)((double)this.fluidInput.amount() * consumptionModifier) : this.fluidInput.amount();
        if (!this.fluidInput.test(input.fluidInput()) || amountNeeded > input.fluidInput().getAmount()) {
            return false;
        }
        if (input.size() != this.ingredients.size()) {
            return false;
        }
        ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>(input.size());
        for (ItemStack item : input.stacks()) {
            if (item.isEmpty()) continue;
            nonEmptyItems.add(item);
        }
        return RecipeMatcher.findMatches(nonEmptyItems, this.ingredients) != null;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.METABOLIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return ModRecipeTypes.METABOLIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<MetabolizerRecipe> {
        public static final MapCodec<MetabolizerRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("item_input").flatXmap(ingredients1 -> {
            Object[] aingredient = (Ingredient[])ingredients1.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for metabolizer recipe");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(MetabolizerRecipe::ingredients), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid_input").forGetter(recipe -> recipe.fluidInput), (App)ItemStack.CODEC.fieldOf("item_output").forGetter(recipe -> recipe.output), (App)FluidStack.CODEC.fieldOf("fluid_output").forGetter(recipe -> recipe.fluidOutput)).apply((Applicative)builder, MetabolizerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MetabolizerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<MetabolizerRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, MetabolizerRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static MetabolizerRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int i = buffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            SizedFluidIngredient fluidInput = (SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)buffer);
            ItemStack itemOutput = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            FluidStack fluidOutput = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            return new MetabolizerRecipe((NonNullList<Ingredient>)nonnulllist, fluidInput, itemOutput, fluidOutput);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, MetabolizerRecipe recipe) {
            buffer.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            SizedFluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluidInput);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluidOutput);
        }
    }
}

