/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.registry;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import piotro15.symbiont.common.registry.ModBlocks;
import piotro15.symbiont.common.registry.ModFluidTypes;
import piotro15.symbiont.common.registry.ModItems;

public class ModFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"symbiont");
    public static final DeferredHolder<Fluid, FlowingFluid> NUTRITIONAL_PASTE = ModFluids.registerFlowingFluid("nutritional_paste");
    public static final DeferredHolder<Fluid, FlowingFluid> SWEET_PASTE = ModFluids.registerFlowingFluid("sweet_paste");
    public static final DeferredHolder<Fluid, FlowingFluid> PROTEIN_PASTE = ModFluids.registerFlowingFluid("protein_paste");
    public static final DeferredHolder<Fluid, FlowingFluid> MYOGENIC_BIOMASS = ModFluids.registerFlowingFluid("myogenic_biomass");
    public static final DeferredHolder<Fluid, FlowingFluid> BIOPOLYMER_SOLUTION = ModFluids.registerFlowingFluid("biopolymer_solution");
    public static final DeferredHolder<Fluid, FlowingFluid> STICKY_PASTE = ModFluids.registerFlowingFluid("sticky_paste");
    public static final DeferredHolder<Fluid, FlowingFluid> FERRIC_SOLUTION = ModFluids.registerFlowingFluid("ferric_solution");
    public static final DeferredHolder<Fluid, FlowingFluid> CUPRIC_SOLUTION = ModFluids.registerFlowingFluid("cupric_solution");
    public static final DeferredHolder<Fluid, FlowingFluid> AURIC_SOLUTION = ModFluids.registerFlowingFluid("auric_solution");
    public static final DeferredHolder<Fluid, FlowingFluid> FERRIC_PASTE = ModFluids.registerFlowingFluid("ferric_paste");
    public static final DeferredHolder<Fluid, FlowingFluid> CUPRIC_PASTE = ModFluids.registerFlowingFluid("cupric_paste");
    public static final DeferredHolder<Fluid, FlowingFluid> ENRICHED_CUPRIC_SOLUTION = ModFluids.registerFlowingFluid("enriched_cupric_solution");
    public static final DeferredHolder<Fluid, FlowingFluid> MARINE_EXTRACT = ModFluids.registerFlowingFluid("marine_extract");

    private static DeferredHolder<Fluid, FlowingFluid> registerFlowingFluid(String name) {
        DeferredHolder[] sourceHolder = new DeferredHolder[1];
        DeferredHolder[] flowingHolder = new DeferredHolder[1];
        DeferredBlock[] blockHolder = new DeferredBlock[1];
        DeferredItem[] bucketHolder = new DeferredItem[1];
        DeferredHolder fluidTypeHolder = ModFluidTypes.FLUID_TYPES.register(name, () -> new FluidType(FluidType.Properties.create()));
        Supplier<BaseFlowingFluid.Properties> propertiesSupplier = () -> new BaseFlowingFluid.Properties((Supplier)fluidTypeHolder, (Supplier)sourceHolder[0], (Supplier)flowingHolder[0]).block((Supplier)blockHolder[0]).bucket((Supplier)bucketHolder[0]).slopeFindDistance(4).levelDecreasePerBlock(2).explosionResistance(100.0f).tickRate(30);
        sourceHolder[0] = FLUIDS.register(name, () -> new BaseFlowingFluid.Source((BaseFlowingFluid.Properties)propertiesSupplier.get()));
        flowingHolder[0] = FLUIDS.register("flowing_" + name, () -> new BaseFlowingFluid.Flowing((BaseFlowingFluid.Properties)propertiesSupplier.get()));
        blockHolder[0] = ModBlocks.BLOCKS.register(name, () -> new LiquidBlock((FlowingFluid)sourceHolder[0].get(), BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).replaceable().noCollission().randomTicks().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid().sound(SoundType.EMPTY)));
        bucketHolder[0] = ModItems.ITEMS.register(name + "_bucket", () -> new BucketItem((Fluid)sourceHolder[0].get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
        return sourceHolder[0];
    }
}

