/*
 * Decompiled with CFR 0.152.
 */
package piotro15.symbiont.common.registry;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import piotro15.symbiont.client.SymbiontClient;
import piotro15.symbiont.common.item.BiotraitExtractItem;
import piotro15.symbiont.common.item.BoneSamplerItem;
import piotro15.symbiont.common.item.CellCultureItem;
import piotro15.symbiont.common.registry.ModBlocks;
import piotro15.symbiont.common.registry.ModCreativeModeTabs;
import piotro15.symbiont.common.registry.ModDataComponents;
import piotro15.symbiont.common.registry.ModRegistries;

public class ModItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"symbiont");
    public static final DeferredItem<BlockItem> RECOMBINATOR = ITEMS.register("recombinator", () -> new BlockItem((Block)ModBlocks.RECOMBINATOR.get(), new Item.Properties()));
    public static final DeferredItem<BlockItem> BIOREACTOR = ITEMS.register("bioreactor", () -> new BlockItem((Block)ModBlocks.BIOREACTOR.get(), new Item.Properties()));
    public static final DeferredItem<BlockItem> METABOLIZER = ITEMS.register("metabolizer", () -> new BlockItem((Block)ModBlocks.METABOLIZER.get(), new Item.Properties()));
    public static final DeferredItem<BlockItem> CENTRIFUGE = ITEMS.register("centrifuge", () -> new BlockItem((Block)ModBlocks.CENTRIFUGE.get(), new Item.Properties()));
    public static final DeferredItem<BlockItem> BIOFORMER = ITEMS.register("bioformer", () -> new BlockItem((Block)ModBlocks.BIOFORMER.get(), new Item.Properties()));
    public static final DeferredItem<Item> CELL_CULTURE = ITEMS.register("cell_culture", () -> new CellCultureItem(new Item.Properties()));
    public static final DeferredItem<Item> BIOTRAIT_EXTRACT = ITEMS.register("biotrait_extract", () -> new BiotraitExtractItem(new Item.Properties()));
    public static final DeferredItem<Item> ORGANIC_BINDER = ITEMS.register("organic_binder", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> BIOPLASTIC_SHEET = ITEMS.register("bioplastic_sheet", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> BONE_SAMPLER = ITEMS.register("bone_sampler", () -> new BoneSamplerItem(new Item.Properties().durability(16)));

    @SubscribeEvent
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        ClientLevel level;
        if (event.getTabKey() == ModCreativeModeTabs.COMMON.getKey()) {
            event.accept(BIOFORMER);
            event.accept(METABOLIZER);
            event.accept(BIOREACTOR);
            event.accept(CENTRIFUGE);
            event.accept(RECOMBINATOR);
            event.accept(ORGANIC_BINDER);
            event.accept(BIOPLASTIC_SHEET);
            event.accept(BONE_SAMPLER);
            SymbiontClient.fluidTypeExtensions.forEach((fluid, extension) -> event.accept((ItemLike)((FlowingFluid)fluid.get()).getBucket()));
        }
        if (event.getTabKey() == ModCreativeModeTabs.CELLS.getKey() && (level = Minecraft.getInstance().level) != null) {
            Registry blendTypeRegistry = level.registryAccess().registryOrThrow(ModRegistries.CELL_TYPE);
            for (ResourceKey blendKey : blendTypeRegistry.registryKeySet()) {
                ItemStack stack = new ItemStack((ItemLike)CELL_CULTURE.get());
                stack.set(ModDataComponents.CELL_TYPE.get(), (Object)blendKey.location());
                event.accept(stack);
            }
            Registry biotraitRegistry = level.registryAccess().registryOrThrow(ModRegistries.BIOTRAIT);
            for (ResourceKey traitKey : biotraitRegistry.registryKeySet()) {
                ItemStack stack = new ItemStack((ItemLike)BIOTRAIT_EXTRACT.get());
                stack.set(ModDataComponents.BIOTRAIT.get(), (Object)traitKey.location());
                event.accept(stack);
            }
        }
    }
}

